# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-25.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29822);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-25");
 script_cve_id("CVE-2007-4575");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-25
(OpenOffice.org: User-assisted arbitrary code execution)


    The HSQLDB engine, as used in Openoffice.org, does not properly enforce
    restrictions to SQL statements.
  
Impact

    A remote attacker could entice a user to open a specially crafted
    document, possibly resulting in the remote execution of arbitrary Java
    code with the privileges of the user running OpenOffice.org.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4575


Solution: 
    All OpenOffice.org users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-office/openoffice-2.3.1"
    All OpenOffice.org binary users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-office/openoffice-bin-2.3.1"
    All HSQLDB users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-db/hsqldb-1.8.0.9"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-25] OpenOffice.org: User-assisted arbitrary code execution");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenOffice.org: User-assisted arbitrary code execution');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-office/openoffice", unaffected: make_list("ge 2.3.1"), vulnerable: make_list("lt 2.3.1")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "app-office/openoffice-bin", unaffected: make_list("ge 2.3.1"), vulnerable: make_list("lt 2.3.1")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "dev-db/hsqldb", unaffected: make_list("ge 1.8.0.9"), vulnerable: make_list("lt 1.8.0.9")
)) { security_warning(0); exit(0); }
