# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29905);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-01");
 script_cve_id("CVE-2007-6610");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-01
(unp: Arbitrary command execution)


    Erich Schubert from Debian discovered that unp does not escape file
    names properly before passing them to calls of the shell.
  
Impact

    A remote attacker could entice a user or automated system to unpack a
    compressed archive with a specially crafted file name, leading to the
    execution of shell commands from within the filename. That code will be
    executed with the privileges of the user running unp.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6610


Solution: 
    All unp users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-arch/unp-1.0.14"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-01] unp: Arbitrary command execution");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'unp: Arbitrary command execution');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-arch/unp", unaffected: make_list("ge 1.0.14"), vulnerable: make_list("lt 1.0.14")
)) { security_warning(0); exit(0); }
