# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29910);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-06");
 script_cve_id("CVE-2007-6531", "CVE-2007-6532");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-06
(Xfce: Multiple vulnerabilities)


    Gregory Andersen reported that the Xfce4 panel does not correctly
    calculate memory boundaries, leading to a stack-based buffer overflow
    in the launcher_update_panel_entry() function (CVE-2007-6531). Daichi
    Kawahata reported libxfcegui4 did not copy provided values when
    creating "SessionClient" structs, possibly leading to access of freed
    memory areas (CVE-2007-6532).
  
Impact

    A remote attacker could entice a user to install a specially crafted
    "rc" file to execute arbitrary code via long strings in the "Name" and
    "Comment" fields or via unspecified vectors involving the second
    vulnerability.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6531
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6532


Solution: 
    All Xfce4 panel users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=xfce-base/xfce4-panel-4.4.2"
    All libxfcegui4 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=xfce-base/libxfcegui4-4.4.2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-06] Xfce: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Xfce: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "xfce-base/libxfcegui4", unaffected: make_list("ge 4.4.2"), vulnerable: make_list("lt 4.4.2")
)) { security_warning(0); exit(0); }
if (qpkg_check(package: "xfce-base/xfce4-panel", unaffected: make_list("ge 4.4.2"), vulnerable: make_list("lt 4.4.2")
)) { security_warning(0); exit(0); }
