# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-11.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(30116);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-11");
 script_cve_id("CVE-2008-0252");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-11
(CherryPy: Directory traversal vulnerability)


    CherryPy does not sanitize the session id, provided as a cookie value,
    in the FileSession._get_file_path() function before using it as part of
    the file name.
  
Impact

    A remote attacker could exploit this vulnerability to read and possibly
    write arbitrary files on the web server, or to hijack valid sessions,
    by providing a specially crafted session id. This only affects
    applications using file-based sessions.
  
Workaround

    Disable the "FileSession" functionality by using "PostgresqlSession" or
    "RamSession" session management in your CherryPy application.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0252


Solution: 
    All CherryPy 2.2 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-python/cherrypy-2.2.1-r2"
    All CherryPy 3.0 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-python/cherrypy-3.0.2-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-11] CherryPy: Directory traversal vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'CherryPy: Directory traversal vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-python/cherrypy", unaffected: make_list("rge 2.2.1-r2", "ge 3.0.2-r1"), vulnerable: make_list("lt 3.0.2-r1")
)) { security_warning(0); exit(0); }
