# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(30120);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-15");
 script_cve_id("CVE-2007-3278", "CVE-2007-4769", "CVE-2007-4772", "CVE-2007-6067", "CVE-2007-6600", "CVE-2007-6601");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-15
(PostgreSQL: Multiple vulnerabilities)


    If using the "expression indexes" feature, PostgreSQL executes index
    functions as the superuser during VACUUM and ANALYZE instead of the
    table owner, and allows SET ROLE and SET SESSION AUTHORIZATION in the
    index functions (CVE-2007-6600). Additionally, several errors involving
    regular expressions were found (CVE-2007-4769, CVE-2007-4772,
    CVE-2007-6067). Eventually, a privilege escalation vulnerability via
    unspecified vectors in the DBLink module was reported (CVE-2007-6601).
    This vulnerability is exploitable when local trust or ident
    authentication is used, and is due to an incomplete fix of
    CVE-2007-3278.
  
Impact

    A remote authenticated attacker could send specially crafted queries
    containing complex regular expressions to the server that could result
    in a Denial of Service by a server crash (CVE-2007-4769), an infinite
    loop (CVE-2007-4772) or a memory exhaustion (CVE-2007-6067). The two
    other vulnerabilities can be exploited to gain additional privileges.
  
Workaround

    There is no known workaround for all these issues at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-3278
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4769
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4772
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6067
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6600
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6601


Solution: 
    All PostgreSQL users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose "dev-db/postgresql"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-15] PostgreSQL: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'PostgreSQL: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/postgresql", unaffected: make_list("ge 8.0.15", "rge 7.4.19", "rge 7.3.21"), vulnerable: make_list("lt 8.0.15")
)) { security_hole(0); exit(0); }
