# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200802-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(30243);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200802-01");
 script_cve_id("CVE-2007-6697", "CVE-2008-0544");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200802-01
(SDL_image: Two buffer overflow vulnerabilities)


    The LWZReadByte() function in file IMG_gif.c and the IMG_LoadLBM_RW()
    function in file IMG_lbm.c each contain a boundary error that can be
    triggered to cause a static buffer overflow and a heap-based buffer
    overflow. The first boundary error comes from some old vulnerable GD
    PHP code (CVE-2006-4484).
  
Impact

    A remote attacker can make an application using the SDL_image library
    to process a specially crafted GIF file or IFF ILBM file that will
    trigger a buffer overflow, resulting in the execution of arbitrary code
    with the permissions of the application or the application crash.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://secunia.com/advisories/28640/
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6697
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0544


Solution: 
    All SDL_image users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-libs/sdl-image-1.2.6-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200802-01] SDL_image: Two buffer overflow vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'SDL_image: Two buffer overflow vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-libs/sdl-image", unaffected: make_list("ge 1.2.6-r1"), vulnerable: make_list("lt 1.2.6-r1")
)) { security_warning(0); exit(0); }
