# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200802-05.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31083);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200802-05");
 script_cve_id("CVE-2008-0668");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200802-05
(Gnumeric: User-assisted execution of arbitrary code)


    Multiple integer overflow and signedness errors have been reported in
    the excel_read_HLINK() function in file plugins/excel/ms-excel-read.c
    when processing XLS HLINK opcodes.
  
Impact

    A remote attacker could entice a user to open a specially crafted XLS
    file, possibly resulting in the remote execution of arbitrary code with
    the privileges of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0668


Solution: 
    All Gnumeric users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-office/gnumeric-1.8.1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200802-05] Gnumeric: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Gnumeric: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-office/gnumeric", unaffected: make_list("ge 1.8.1"), vulnerable: make_list("lt 1.8.1")
)) { security_warning(0); exit(0); }
