# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200802-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31085);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200802-07");
 script_cve_id("CVE-2008-0008");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200802-07
(Pulseaudio: Privilege escalation)


    Marcus Meissner from SUSE reported that the pa_drop_root() function
    does not properly check the return value of the system calls setuid(),
    seteuid(), setresuid() and setreuid() when dropping its privileges.
  
Impact

    A local attacker could cause a resource exhaustion to make the system
    calls fail, which would cause Pulseaudio to run as root. The attacker
    could then perform actions with root privileges.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0008


Solution: 
    All Pulseaudio users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-sound/pulseaudio-0.9.9"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200802-07] Pulseaudio: Privilege escalation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Pulseaudio: Privilege escalation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-sound/pulseaudio", unaffected: make_list("ge 0.9.9"), vulnerable: make_list("lt 0.9.9")
)) { security_hole(0); exit(0); }
