# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200802-10.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31158);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200802-10");
 script_cve_id("CVE-2006-7228");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200802-10
(Python: PCRE Integer overflow)


    Python 2.3 includes a copy of PCRE which is vulnerable to an integer
    overflow vulnerability, leading to a buffer overflow.
  
Impact

    An attacker could exploit the vulnerability by tricking a vulnerable
    Python application to compile a regular expressions, which could
    possibly lead to the execution of arbitrary code, a Denial of Service
    or the disclosure of sensitive information.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2006-7228
    http://www.gentoo.org/security/en/glsa/glsa-200711-30.xml


Solution: 
    All Python 2.3 users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/python-2.3.6-r4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200802-10] Python: PCRE Integer overflow");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Python: PCRE Integer overflow');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/python", unaffected: make_list("ge 2.3.6-r4"), vulnerable: make_list("lt 2.3.6-r4")
)) { security_warning(0); exit(0); }
