# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200803-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31328);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200803-01");
 script_cve_id("CVE-2007-1199", "CVE-2007-5659", "CVE-2007-5663", "CVE-2007-5666", "CVE-2008-0655", "CVE-2008-0667", "CVE-2008-0726");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200803-01
(Adobe Acrobat Reader: Multiple vulnerabilities)


    Multiple vulnerabilities have been discovered in Adobe Acrobat Reader,
    including:
    A file disclosure when using file:// in PDF documents
    (CVE-2007-1199)
    Multiple buffer overflows in unspecified Javascript methods
    (CVE-2007-5609)
    An unspecified vulnerability in the Escript.api plugin
    (CVE-2007-5663)
    Incorrect handling of printers (CVE-2008-0667)
    An integer overflow when passing incorrect arguments to
    "printSepsWithParams" (CVE-2008-0726)
  
Impact

    A remote attacker could entice a user to open a specially crafted
    document, possibly resulting in the remote execution of arbitrary code
    with the privileges of the user running the application. A remote
    attacker could also perform cross-site request forgery attacks, or
    cause a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-1199
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5659
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5663
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5666
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0655
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0667
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0726


Solution: 
    All Adobe Acrobat Reader users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-text/acroread-8.1.2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200803-01] Adobe Acrobat Reader: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Adobe Acrobat Reader: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-text/acroread", unaffected: make_list("ge 8.1.2"), vulnerable: make_list("lt 8.1.2")
)) { security_warning(0); exit(0); }
