# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200803-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31382);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200803-07");
 script_cve_id("CVE-2008-0299");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200803-07
(Paramiko: Information disclosure)


    Dwayne C. Litzenberger reported that the file "common.py" does not
    properly use RandomPool when using threads or forked processes.
  
Impact

    A remote attacker could predict the values generated by applications
    using Paramiko for encryption purposes, potentially gaining access to
    sensitive information.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0299


Solution: 
    All Paramiko users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-python/paramiko-1.7.2"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200803-07] Paramiko: Information disclosure");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Paramiko: Information disclosure');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-python/paramiko", unaffected: make_list("ge 1.7.2"), vulnerable: make_list("lt 1.7.2")
)) { security_warning(0); exit(0); }
