# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200803-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31387);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200803-12");
 script_cve_id("CVE-2008-0072");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200803-12
(Evolution: Format string vulnerability)


    Ulf Harnhammar from Secunia Research discovered a format string error
    in the emf_multipart_encrypted() function in the file mail/em-format.c
    when reading certain data (e.g. the "Version:" field) from an encrypted
    e-mail.
  
Impact

    A remote attacker could entice a user to open a specially crafted
    encrypted e-mail, potentially resulting in the execution of arbitrary
    code with the privileges of the user running Evolution.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0072


Solution: 
    All Evolution users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=mail-client/evolution-2.12.3-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200803-12] Evolution: Format string vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Evolution: Format string vulnerability');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "mail-client/evolution", unaffected: make_list("ge 2.12.3-r1"), vulnerable: make_list("lt 2.12.3-r1")
)) { security_warning(0); exit(0); }
