#
#  (C) 2007 Tenable Network Security
#

desc = "
Synopsis :

The remote host has an application installed that is vulnerable to a
local cross-site scripting vulnerability. 

Description :

The version of Google Desktop installed on the remote host is
vulnerable to a cross-site scripting flaw because it fails to properly
encode the output for the 'under' keyword.  This issue cannot be
directly exploited remotely, however when used in conjunction with a
known Google.com cross-site scripting vulnerability to extract the
unique signature associated with Google Desktop software, and might
allow an attacker to query a victim's system for sensitive
information. 

See also :

http://download.watchfire.com/googledesktopdemo/index.htm
http://download.watchfire.com/whitepapers/Overtaking-Google-Desktop.pdf
http://desktop.google.com/support/bin/answer.py?answer=14280

Solution:

Google Desktop automatically updates itself when a new version of the
software is available.  However in some cases it may not be able to
update itself due to network connectivity issues.  Please ensure that
Google Desktop version 5.0.0701.30540 or later is installed. 

Risk factor :

High / CVSS Base Score : 7.6
(CVSS2#AV:N/AC:H/Au:N/C:C/I:C/A:C)";


if (description) 
{
  script_id(24710);
  script_bugtraq_id(22650);
  script_cve_id("CVE-2007-1085");	
  script_xref(name:"CERT",value:"615857");		
  script_version("$Revision: 1.4 $");
  script_name(english:"Google Desktop Cross-Site Scripting Flaw");
  script_summary(english:"Checks version of Google Desktop"); 
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("google_desktop_installed.nasl");
  script_require_keys("SMB/Google/Google Dektop/version");
  script_require_ports(139, 445);

  exit(0);
}

include("global_settings.inc");

ver = get_kb_item("SMB/Google/Google Dektop/version");
ver = split(ver, sep:".",keep:FALSE);

if (!isnull(ver))
  {
    fix = split("5.0.701.30540", sep:'.', keep:FALSE);
    for (i=0; i<4; i++)
      fix[i] = int(fix[i]);

    for (i=0; i<max_index(ver); i++)
     { 	
      if ((ver[i] < fix[i]))
      {
        security_hole(port:port);
	exit(0);
      }
      else if (ver[i] > fix[i])
        break;
     }
  }
