#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote RTSP server is prone to a buffer overflow attack. 

Description :

The remote host is running Helix Server or Helix DNA Server, a media
streaming server. 

The version of the Helix server installed on the remote host
reportedly contains a heap overflow that is triggered using an RTSP
command with multiple 'Require' headers.  An unauthenticated remote
attacker can leverage this flaw to execute arbitrary code subject to
the privileges under which it operates, by default LOCAL SYSTEM on
Windows. 

See also :

http://www.nessus.org/u?dabedd30
http://archives.neohapsis.com/archives/fulldisclosure/2007-08/0432.html

Solution :

Upgrade to Helix Server / Helix DNA Server version 11.1.4 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25950);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-4561");
  script_bugtraq_id(25440);
  script_xref(name:"OSVDB", value:"39903");

  script_name(english:"Helix Server RTSP Multiple Requires Overflow Vulnerability");
  script_summary(english:"Checks Helix server banner");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("find_service2.nasl");
  script_require_ports("Services/rtsp", 554);

  exit(0);
}


include("http_func.inc");


port = get_kb_item("Services/rstp");
if (!port) port = 554;
if (!get_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Grab the banner.
req = string(
  "OPTIONS * RTSP/1.0\r\n", 
  "CSeq: 1\r\n",
  "\r\n"
);
send(socket:soc, data:req);
res = http_recv(socket:soc);
close(soc);
if (res == NULL) exit(0);


# Pull out the server information.
server = egrep(pattern:"^Server:", string:res);
if (!server) 
{
  via = egrep(pattern:"^Via: .*\(.*\)", string:res);
  if (via) server = ereg_replace(pattern:"^Via: .*\((.*)\).*", replace:"\1", string:via);
}
else server -= "Server: ";


# If it's Helix Server / Helix DNA Server...
if (
  stridx(server, "Helix Server Version") == 0 || 
  stridx(server, "Helix DNA Server Version") == 0
)
{
  ver = ereg_replace(pattern:"^.+Version ([0-9\.][^ ]+) .+$", replace:"\1", string:server);
  if (ver)
  {
    iver = split(ver, sep:'.', keep:FALSE);
    for (i=0; i<max_index(iver); i++)
      iver[i] = int(iver[i]);

    fix = split("11.1.4.0", sep:'.', keep:FALSE);
    for (i=0; i<max_index(fix); i++)
      fix[i] = int(fix[i]);

    for (i=0; i<max_index(iver); i++)
      if ((iver[i] < fix[i]))
      {
        prod = server - strstr(server, " Version");

        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "According to its banner, the remote host is running ", prod, "\n",
          "version ", ver, "."
        );
        security_hole(port:port, data:report);
        break;
      }
      else if (iver[i] > fix[i])
        break;
  }
}
