#
# (C) Tenable Network Security
#
#

if (description)
{
 script_id(16060);
 script_cve_id("CVE-2004-2602", "CVE-2004-2603");
 script_bugtraq_id(12105);
 if (defined_func("script_xref")) {
   script_xref(name:"OSVDB", value:"12597");
   script_xref(name:"OSVDB", value:"12598");
   script_xref(name:"OSVDB", value:"12631");
 }
 script_version ("$Revision: 1.5 $");

 script_name(english:"Help Center Live Multiple Vulnerabilities");
 desc["english"] = "
Synopsis :

The remote web server contains a PHP application that is prone to
multiple attacks. 

Description :

The remote host is running Help Center Live, a help desk application
written in PHP. 

The remote version of this software is vulnerable to various flaws,
including one that may allow an attacker to execute arbitrary commands
on the remote host subject to the privileges of the web server user id
provided PHP's 'register_globals' setting is enabled. 

See also :

http://www.gulftech.org/?node=research&article_id=00058-12242004

Solution : 

Unknown at this time.

Risk factor : 

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";

 script_description(english:desc["english"]);
 script_summary(english:"Determines if Help Center Live can include third-party files");
 script_category(ACT_GATHER_INFO);
 script_family(english:"CGI abuses");
 script_copyright(english:"This script is Copyright (C) 2004-2007 Tenable Network Security");
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

foreach d (cgi_dirs())
{
 url = string(d, "/inc/pipe.php?HCL_path=http://xxxxxx./");
 req = http_get(item:url, port:port);
 buf = http_keepalive_send_recv(port:port, data:req);
 if( buf == NULL ) exit(0);
 if ( "http://xxxxxx./inc/DecodeMessage.inc" >< buf )
 {
  security_warning(port);
  exit(0);
 }
}
