#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(27056);
  script_version("$Revision: 1.2 $");

  script_name(english:"HP Linux Imaging and Printing System HPSSD Daemon Detection");
  script_summary(english:"Sends a queryhistory request");

  desc = "
Synopsis :

A printing service is listening on the remote host. 

Description :

The remote service is an hpssd daemon, a component of the HP Linux
Imaging and Printing (HPLIP) System that provides various services to
HPLIP client applications. 

See also :

http://hplip.sourceforge.net/

Solution :

Limit incoming traffic to this port if desired.

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/unknown", 2207);

  exit(0);
}


include("global_settings.inc");
include("misc_func.inc");


if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery")  )
{
  port = get_unknown_svc(2207);
  if (!port) exit(0);
}
else port = 2207;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Query history of a device-uri.
uri = "hp:/net/deskjet_5800?ip=127.0.0.1";

req = string(
  "device-uri=", uri, "\n",
  "msg=queryhistory\n"
);
send(socket:soc, data:req);
res = recv(socket:soc, length:1024, min:22);
close(soc);


# Register and report the service if we see a valid result.
if (strlen(res) && "msg=queryhistoryresult" >< res)
{
  register_service(port:port, proto:"hpssd");
  security_note(port);
}
