#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30202);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2008-0437");
  script_bugtraq_id(27384);
  script_xref(name:"OSVDB", value:"40890");

  script_name(english:"HP Virtual Rooms WebHPVCInstall.HPVirtualRooms14 ActiveX Control Buffer Overflow Vulnerabilities");
  script_summary(english:"Checks version of WebHPVCInstall.HPVirtualRooms14 ActiveX control"); 
 
 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is affected by
multiple buffer overflow vulnerabilities. 

Description :

The remote host contains a version of the HP Virtual Rooms
WebHPVCInstall.HPVirtualRooms14 ActiveX control that reportedly is
affected by multiple buffer overflows involving properties such as
'AuthenticationURL', 'PortalAPIURL', and 'cabroot'.  If a remote
attacker can trick a user on the affected host into visiting a
specially-crafted web page, he may be able to leverage this issue to
execute arbitrary code on the affected host subject to the user's
privileges. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2008-01/0461.html
http://www.securityfocus.com/archive/1/487654

Solution :

Upgrade to HP Virtual Rooms v7 or use the HPVR removal tool referenced
in the vendor advisory above to remove the software. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate the file used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "00000014-9593-4264-8B29-930B3E4EDCCD}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  report = NULL;
  if (report_paranoia > 1)
    report = string(
      "\n",
      "The vulnerable control is installed as :\n",
      "\n",
      "  ", file, "\n",
      "\n",
      "Note, though, that Nessus did not check whether the 'kill' bit was\n",
      "set for the control's CLSID because of the Report Paranoia setting\n",
      "in effect when this scan was run.\n"
    );
  else if (activex_get_killbit(clsid:clsid) != TRUE)
    report = string(
      "\n",
      "The vulnerable control is installed as :\n",
      "\n",
      "  ", file, "\n",
      "\n",
      "Moreover, its 'kill' bit is not set so it is accessible via Internet\n",
      "Explorer.\n"
    );

  if (report)
  {
    if (report_verbosity) security_hole(port:kb_smb_transport(), extra:report);
    else security_hole(kb_smb_transport());
  }
}
activex_end();
