#
# This script was written by Michel Arboi
#
# 10/03/2007 - cleaned up by Tenable Network Security
#

if(description)
{
 script_id(10498);
 script_version ("$Revision: 1.34 $");
 script_bugtraq_id(12141);
 script_xref(name:"OSVDB", value:"397");
 script_xref(name:"OSVDB", value:"5646");
 script_xref(name:"OWASP", value:"OWASP-CM-001");
 
 name["english"] = "Test HTTP dangerous methods";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server allows PUT and/or DELETE method(s). 

Description :

The PUT method allows an attacker to upload arbitrary web pages on 
the server. If the server is configured to support scripts like ASP
or PHP it will allow the attacker to execute code with the privileges
of the web server.

The DELETE method allows an attacker to delete arbitrary content from
the web server.

Solution :

Disable PUT and/or DELETE method(s) in the web server configuration.

Risk factor :

High / CVSS Base Score : 7.5 
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Verifies the access rights to the web server (PUT, DELETE)";
 
 script_summary(english:summary["english"]);
 script_category(ACT_ATTACK);
 
 script_copyright(english:"This script is Copyright (C) 2000 Michel Arboi");
		
 family["english"] = "Remote file access";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "no404.nasl");
 script_require_ports("Services/www", 80);

 exit(0);
}

include("http_func.inc");

function exists(file, port)
{
 local_var _soc, req, r, buf;

 _soc = http_open_socket(port);
 if (!_soc)
   return 0;

 req = http_get(item:file, port:port);

 send(socket:_soc, data:req);
 r = recv_line(socket:_soc, length:4096);
 buf = http_recv(socket: _soc, code: r);

 close(_soc);

 if ( ereg(pattern:"^HTTP/[0-9]\.[0-9] 200 .*", string:r) && ("A quick brown fox jumps over the lazy dog" >< buf) )
   return 1;

 return 0;
}


delete = upload = 0;

port = get_http_port(default:80);

if ( !get_port_state(port) ) exit(0);
if ( get_kb_item("Services/www/" + port + "/embedded" ) ) exit(0);

soc = http_open_socket(port);
if (!soc)
  exit(0);

# look for Allow field
req = http_get(item: "*", port: port);
req = str_replace(string: req, find: "GET", replace: "OPTIONS", count: 1);
send(socket: soc, data: req);
r = http_recv(socket: soc);

allow = egrep(string: r, pattern: "^Allow:");

soc = http_open_socket(port);
if (!soc) exit(0);

name = NULL;

for (i=1; i <= 20; i++)
{
 if (exists(file:string("/puttest", i,".html"), port:port) == 0)
 {
  name = string("/puttest", i, ".html");
  break;
 }
}

if (isnull(name))
  exit(0);

c = crap(length:77, data:"A quick brown fox jumps over the lazy dog");

req = http_put(item:name, port:port, data:c);
send(socket:soc, data:req);

l = recv_line(socket:soc,length:1024);
close(soc);

if (exists(port:port, file:name))
  upload = 1;
else if (" 401 " >< l && "PUT" >< allow)
  upload = 2;
else
  upload = 0;


if (upload == 1)
{ 
 soc = http_open_socket(port);
 if (!soc)
   exit(0);

 req = http_delete(item:name, port:port);
 send(socket:soc, data: req);
 l = recv_line(socket:soc, length:1024);

 if (" 200 " >< l)
 {
  if (exists(port:port, file:name) == 0)
    delete = 1;
  else if (" 401 " >< l && " is disabled " >!< l && "DELETE" >< allow)
    delete = 2;
  else
    delete = 0;  
 }
}


# if we were not able to test DEL and PUT we just quit
if (delete != 1 && upload != 1)
  exit(0);


report = NULL;

if (delete == 1 || upload == 1)
{
 report += "The following methods are available on the web server:\n";

 if (upload == 1)
   report += string(" - PUT : the file '", name, "' as been uploaded on the web server\n");
 if (delete == 1)
   report += string(" - DELETE : the file '", name, "' as been deleted from the web server\n");
}

if (delete == 2 || upload == 2)
{
 report += string (
		"The following methods are available on the web server, but Nessus\n",
		"was not able to test them:\n"
	);

 if (upload == 2)
   report += string(" - PUT");
 if (delete == 2)
   report += string(" - DELETE");
}

if (report)
  security_hole(port);