#TRUSTED 0b5b2570b11661a202923c7f1e98b074cb6641450e6dd5188f98cd1364b5fcecbe9fd6b35599d3fcbe1a0cdf75f3cd8e4a14f21ffa7c7a563cc4f268103806768989813223b7e10d5fceb6eeccfb2b9e8b906bafd1880e79b1ced03753f66b7cb0929e61eb985869badeda49b4aa42a7465d30b1d3fcd343e0c2da30af9f9d189ace2fd6360502136ddfe76d890c7eb75dd75f962b04d542cfc2bad466a6e9d392315059106e26865dee72342efabdc76affdbb5b87d90fb3964a180e077f7ce317f3312b69fd1da591113b1c87cbe526c1fc5de1c052c57ebac59dad864a4b0cb0bd655d09201bd49b6ecf17b44a959202ee119b682da84188a2c4e86249544006c1be00d2c006449f2515a0c7c5e3ccb6d528c6d3cc94a8f16a6b77a5f4528468cc82dd33a036abb62066efdbd9ab37a1deda192590a21df7433ceea76bd484d7b2b0f63fc46a63518ed9ee6a08591749709dfbb35a6a798a8919b65eef41530036510438e01d8d7210293371f4afefaf1f0838d75c321daed42d620c61b5bd41cde63b3782435e1cc443953c47976b026ef2d8ff41ec1569c825b90717767f83ac314dbcf2b3c2dc01eec72465d3036913ef899e0cecc1c94d84e354c0e0d61c4035ebe2adc67360718cfffbc101fd1cf194920c30048f7fa2ef48eefbce23dc19643f9d6b0496a043eed6c13383eab874d174c7cf5894064cb2f40d87ec9
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15873);
 script_version ("1.3");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-004");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-006");
 script_xref(name: "OWASP", value: "OWASP-AUTHN-010");
 name["english"] = "Hydra: HTTP";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find HTTP passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force HTTP authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 
 script_add_preference(name: "Web page :", value: "", type: "entry");

 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/www", 80);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/www");
if (! port) exit(0);	# port = 80;
if (! get_port_state(port)) exit(0);
if ( get_kb_item("Services/www/" + port + "/broken") ) exit(0);

# Check that the server is up & running
soc = open_sock_tcp(port);
if (! soc) exit(0);
send(socket: soc, data: 'GET / HTTP/1.0\r\n\r\n');
r = recv_line(socket: soc, length: 4096);
close(soc);
if (r !~ '^HTTP/1\\.[01] +[0-9][0-9][0-9] ') exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
#if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
if ( tr >= ENCAPS_SSLv2 )
 argv[i++] = "https-get";
else
 argv[i++] = "http-get";

opt = script_get_preference("Web page :");
if (! opt)
{
  v = get_kb_list('www/'+port+'/content/auth_required');
  if (!isnull(v)) opt = v[0];
}
if (! opt) exit(0);
# Check that web page is forbidden
soc = http_open_socket(port);
if (! soc) exit(0);
send(socket: soc, data: 
 strcat('GET ', opt, ' HTTP/1.1\r\nHost: ', get_host_name(), '\r\n\r\n'));
r = recv_line(socket: soc, length: 512);
http_close_socket(soc);
if (r =~ '^HTTP/1\\.[01] +40[13] ') exit(0);
#
argv[i++] = opt;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'username: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/http/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following HTTP accounts:\n' + report);
