#TRUSTED 2746072fb06cc92acf4d52742285411d29ffb22a997c28dbc82083758f41bb90d64690e147f11d4784111abc84b7b07d03ef95e5d79460256eed4b8c48215004c284b6d4aa2ec31ef4cdc035927a2c6b51fcdc9b654c46b58e4df8eaf44ed99b4c2dfdb4ab0d44b9afcedf8d61e9088ca0182d3ccbd061c19dffb717195c972b81891d12e7ee0fb536d9301290a122f31bdd2d31dcc32d11cc8b059b450002f3a3cbc93d6ed11774b7c567300e99231edf7781526ad5a2b797e9c1e327a729c7f4dc1779fad8709a35cb98c3022e8cfe64e2e578439329580b7d8f62e10228795a351530efa3eab16067d92240720d74c89305040b5136f7aa6e820e9d8a199b3f9f27aa2b594292194f6dca59c702a42671e49e757af64c06a0a230a13bf664967f5c35a90365b287da98c2cf6acd1d45b52114adcd95426847409dbf1e53913cc0569d24fff394447595e72cf5c3244744457afd989285726c48641d84e5743a2dbd7b5706c4cdd91d1c41ba4c8198948b2d7e647b5d75c8b6395c09de2997fa3bcb6a24d5b14dc547b268915ccfa07650c8988c2c79c198bd66be1bd858bbad7d173e7e780fb7e8ba5403f67c72b7ce2e65f99fb630160a40d04a6565e146623c1cf4ed8417330e2252e3fc76fe2232a3e3b0c1249552a00eddd2d6c942ab5a3a483e529ce73f2462c982a7ca80bbc210127a99ef1f872d1cf637a99184b8
#
# This script was written by Michel Arboi <mikhail@nessus.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(18661);
 script_version ("1.2");
 name["english"] = "Hydra: MySQL";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find MySQL accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force MySQL authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);

 script_copyright(english:"This script is Copyright (C) 2005 Michel Arboi <mikhail@nessus.org>");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/mysql", 3306);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl", "mysql_version.nasl", "mysql_unpassworded.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
 throrough = get_kb_item("global_settings/thorough_tests");
 if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/mysql");
if (! port) exit(0);
if (! get_port_state(port)) exit(0);

no_pass = get_kb_item('MySQL/no_passwd/'+port);
if (no_pass) exit(0);

# We should check that the server is up & running

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (!s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "mysql";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/mysql/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the MySQL server:\n' + report);
