#TRUSTED 83c2fbab3fafe4d5b2143b7d262920c84d5235463f3072ae0938eae5109f14c2cfeb1760c0c2ec8584f24f134a080fae2f813422c788502391fb645ca4e8a0bb2c03e8563e69a65086bb3ec76d8e52b98e17d86c8ff4a44ef7db1b5431069837afc5f20c16038e77f3971b8dfa5a95845f4a45e3244302dda26c12bec7692cd01ad4866325e780c38834a912135f4daa9843a0096561c7a5aac6e651c3718819bb7925a5397b390f918687b9b89549e16867d79464a0d365a536b7015353a138e6fecffe4f6ed39407b4d28237196ffaee2f34cac7284599c62632b9a6efbf3f27106620e49055c3f5ca9df75dfbb7c236da6aeb1ec4c51846c411ce7d51a33fd8c674624ba94b8a24043f494645a18e9ebb90397e455b68a0333258ef3ca87bc60e9fffe8a7724e7d73e3f8c8b61c11ebb364d28ee22039e146257f713d0a5ddcb34927e4cce0566aa7a8d4a3a438b9e77e6608cf26b660eb6f1181db54d36e58195781af69e27eeab0a31c8b919c873b4e00c93ecc65ed3b605fe4ead103dc0ea80a4fb08fb8461c18d7486859b3db3d6b5fcaa43cc280ce0416f82f9b59bcc4879378e34236d78cf60c8b11cac8ea6f84cafd0475cbf36b2bfb5d2801dc2427981a838311a756e9c3c8d010bdadba38d3831373cbb5108039b74f6e2b8ec43abb6c8fcea3acd6bf0cd2b13f9cfc100cb845b442779cfc88e9fe866d8bd6f3
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

# No use to run this one if the other plugins cannot run!
if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra") ) exit(0);


if(description)
{
 script_id(15868);
 script_version ("1.3");
 name["english"] = "Hydra (NASL wrappers options)";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin sets options for the hydra(1) tests.
Hydra finds passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force authentication protocols";
 script_summary(english:summary["english"]);
 
 script_category(ACT_SETTINGS);
 
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");

 script_add_preference(name: "Always enable Hydra (slow)", type:"checkbox", value: "no");
 script_add_preference(name: "Logins file : ", value: "", type: "file");
 script_add_preference(name: "Passwords file : ", value: "", type: "file");
 script_add_preference(name: "Number of parallel tasks :", value: "16", type: "entry");
 script_add_preference(name: "Timeout (in seconds) :", value: "30", type: "entry");
 script_add_preference(name: "Try empty passwords", type:"checkbox", value: "yes");
 script_add_preference(name: "Try login as password", type:"checkbox", value: "yes");
 script_add_preference(name: "Exit as soon as an account is found", type:"checkbox", value: "no");
 script_add_preference(name: "Add accounts found by other plugins to login file", type:"checkbox", value: "yes");

 exit(0);
}

#

function mk_login_file(logins)
{
  local_var	tmp1,tmp2, dir, list, i, u;
  if ( NASL_LEVEL < 2201 ) return logins; # fwrite broken
  dir = get_tmp_dir();
  if (! dir) return logins;	# Abnormal condition
  for (i = 1; TRUE; i ++)
  {
    u = get_kb_item("SMB/Users/"+i);
    if (! u) break;
    list = strcat(list, u, '\n');
  }
# Add here results from other plugins
  if (! list) return logins;
  tmp1 = strcat(dir, 'hydra-'+ get_host_ip() + '-' + rand());
  tmp2 = strcat(dir, 'hydra-'+ get_host_ip() + '-' + rand());
  if (fwrite(data: list, file: tmp1) <= 0)	# File creation failed
    return logins;
  if (! logins) return tmp1;
  pread(cmd: "sort", argv: make_list("sort", "-u", tmp1, logins, "-o", tmp2));
  unlink(tmp1);
  return tmp2;
}


if ( ! script_get_preference("Passwords file : ") ) exit(0);
p = script_get_preference_file_location("Passwords file : ");
if (!p ) exit(0);
set_kb_item(name: "Secret/hydra/passwords_file", value: p);

# No login file is necessary for SNMP, VNC and Cisco; and a login file 
# may be made from other plugins results. So we do not exit if this
# option is void.
a = script_get_preference("Add accounts found by other plugins to login file");
if ( ! script_get_preference("Logins file : ") ) exit(0);
p = script_get_preference_file_location("Logins file : ");
if ("no" >!< a) p = mk_login_file(logins: p);
set_kb_item(name: "Secret/hydra/logins_file", value: p);

p = script_get_preference("Timeout (in seconds) :");
t = int(p);
if (t <= 0) t = 30;
set_kb_item(name: "/tmp/hydra/timeout", value: t);

p = script_get_preference("Number of parallel tasks :");
t = int(p);
if (t <= 0) t = 16;
set_kb_item(name: "/tmp/hydra/tasks", value: t);

p = script_get_preference("Try empty passwords");
if ( "yes" >< p ) 
  set_kb_item(name: "/tmp/hydra/empty_password", value: TRUE);

p = script_get_preference("Try login as password");
if ( "yes" >< p ) 
 set_kb_item(name: "/tmp/hydra/login_password", value: TRUE);

p = script_get_preference("Exit as soon as an account is found");
if ( "yes" >< p ) 
 set_kb_item(name: "/tmp/hydra/exit_ASAP", value: TRUE);

p = script_get_preference("Always enable Hydra (slow)");
if ("yes" >< p)
 set_kb_item(name: "/tmp/hydra/force_run", value: TRUE);
