#TRUSTED 5367c6d8e392e72fa3c0fd9d08f29f97c57969e6b1d8df03f848a14e595f9ff5620f7f04d3c010cfe017cf2ac3231dd598d7750ed6abeab3ee5702d85f40ebe622ddf543d4cd887687808830a61d8fde58e02337dbe3cf68b2c99b1aff7fa7a1ed4ef89542bb53d896a97a6113e66d34864663f68f484eaf1d702895c14a5c408f46b2cc4476c40e7abc12a6a9d74fbcd9e63297f030d0b25c7fd8bcf1199f60aed94d597a82be972c1bab91eced5009e926bde8985c585f91a9c88252ab3c87d448d1cd5acb2067cac588b6c564d57192ed22aca77f5377fd395d5505f3029360db9b687d8693aa6178c09be6037be58db4bd5fc1e0c07ee3a3665276a819c0a5728a032be409b2be76940a9460faedf5234d52b5bb52d3a17dc93ba61697d865c7c18dba0010e69f578352533f64a95b88f9d82517485cb2b7133be9a7c3baf115c2dff388c7ad511a2fee23916a03fd64c9ecb448bc43c955026303f6fc29f03a07777d513341980cabfb0cb364b2601af49b4aaa38c1d32272d9923c597856b2b7bd1b524049b3e9c2009cacd74b8124596b4aee5e4358497daf84015d683a889308a45fd2da2a9b5857f0d1a5a0582a311d210acddd781ed53ea5bf54cae810a9536ffb3e0f6d0b9cecaf49178b9cce766c1f0b55340b449dcece3afd551a41ea32e37cef031eb48a71e948050fb3243874b7d03c9341cc68ed7e4d02d7
#
# This script was written by Michel Arboi <mikhail@nessus.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(18660);
 script_version ("1.3");
 name["english"] = "Hydra: Postgres";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find Postgres accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force Postgres authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_add_preference(name: "Database name (optional) : ", type: "entry", value: "");

 script_copyright(english:"This script is Copyright (C) 2005 Michel Arboi <mikhail@nessus.org>");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/postgres", 5432);
 script_dependencies("hydra_options.nasl", "find_service1.nasl", "doublecheck_std_services.nasl", "postgresql_unpassworded.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
 throrough = get_kb_item("global_settings/thorough_tests");
 if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/postgres");
if (! port) exit(0);	# port = 5432;
if (! get_port_state(port)) exit(0);

nopass = get_kb_item('postgresql/no_pass/'+port);
if (nopass) exit(0);

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);
db = script_get_preference("Database name (optional) : ");

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;

s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (! s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "postgres";
if (db) argv[i++] = db;

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/postgres/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following accounts on the Postgres server:\n' + report);
