#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

A service on the remote host is prone to a denial of service attack. 

Description :

The remote host is running IBM Tivoli Provisioning Manager for OS
Deployment, for remote deployment and management of operating systems. 

The TFTPD component of the version of this software installed on the
remote host does not handle read requests with an invalid 'blksize'
argument.  An unauthenticated attacker can leverage this issue to
trigger a divide-by-zero error and cause the 'rembo.exe' service to
exit. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=560
http://www.securityfocus.com/archive/1/473925/30/0/threaded
http://www-1.ibm.com/support/docview.wss?uid=swg24016347

Solution :

Upgrade to Tivoli Provisioning Manager for OS Deployment, Fix Pack 3
(version 5.1.0.3) or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";


if (description)
{
  script_id(25738);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-3268");
  script_bugtraq_id(24942);
  script_xref(name:"OSVDB", value:"38160");

  script_name(english:"IBM Tivoli Provisioning Manager for OS Deployment TFTPD Blocksize Denial of Service Vulnerability");
  script_summary(english:"Gets IBM TPM for OS Deployment Server version");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Denial of Service");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "tftpd_detect.nasl");
  script_require_keys("Services/udp/tftp");
  script_require_ports("Services/www", 443, 8080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


# Unless we're paranoid, make sure there's a TFTP service.
if (
  report_paranoia < 2 && 
  !get_kb_item("Services/udp/tftp")
) exit(0);


port = get_http_port(default:443);
if (!get_port_state(port)) exit(0);


# Grab the main page.
res = http_get_cache(item:"/builtin/index.html", port:port);
if (res == NULL) exit(0);


# If it looks like TPMfOSd...
if (
  "Server: Rembo" >< res &&
  "IBM Tivoli Provisioning Manager for OS Deployment" >< res
)
{
  # Pull out the version number.
  ver = NULL;
  build = NULL;

  pat = ">TPMfOSd ([0-9][0-9.]+) \(build ([0-9][0-9.]+)\)<";
  matches = egrep(pattern:pat, string:res);
  if (matches)
  {
    foreach match (split(matches))
    {
      match = chomp(match);
      item = eregmatch(pattern:pat, string:match);
      if (!isnull(item))
      {
        ver = item[1];
        build = item[2];
        break;
      }
    }
  }

  if (!isnull(ver))
  {
    iver = split(ver, sep:'.', keep:FALSE);
    for (i=0; i<4; i++)
      iver[i] = int(iver[i]);

    fix = split("5.1.0.3", sep:'.', keep:FALSE);
    for (i=0; i<4; i++)
      fix[i] = int(fix[i]);

    for (i=0; i<max_index(iver); i++)
      if ((iver[i] < fix[i]))
      {
        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "According to its banner, version ", ver, " (build ", build, ") of IBM Tivoli\n",
          "Provisioning Manager for OS Deployment is installed on the remote\n",
          "host."
        );
        security_warning(port:port, data:report);
        break;
      }
      else if (iver[i] > fix[i])
        break;
  }
}
