#
# (C) Tenable Network Security
#

if(description)
{
 script_id(25662);
 script_version("$Revision: 1.4 $");
 script_cve_id("CVE-2006-5855");
 script_bugtraq_id(21440);
 script_xref(name:"OSVDB", value:"31764");
 script_xref(name:"OSVDB", value:"31765");
 script_xref(name:"OSVDB", value:"31766");

 name["english"] = "IBM Tivoli Storage Manager Multiple Buffer Overflow Vulnerabilities";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host.

Description :

The remote host is running a version of IBM Tivoli Storage Manager
which is vulnerable to multiple buffer overflows.  An attacker may
exploit these flaws to execute arbitrary code on the remote host or to
disable this service remotely. 

To exploit this flaw, an attacker would need to send a specially
crafted packet to the remote service. 

See also :

http://dvlabs.tippingpoint.com/advisory/TPTI-06-14
http://www-1.ibm.com/support/docview.wss?uid=swg21251473

Solution :

Upgrade to :

- Tivoli Storage Manager >= 5.2.9
- Tivoli Storage Manager >= 5.3.4
- Tivoli Storage Manager Express >= 5.3.7.1

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Test the IBM TSM buffer overflows";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);
 
 script_require_keys("IBM/TSM/Version");
 script_dependencies("ibm_tsm_detect.nasl");
 script_require_ports(1500);
 exit(0);
}


version = get_kb_item("IBM/TSM/Version");
isExpress = get_kb_item("IBM/TSM/isExpress");

if (isnull(version))
  exit(0);

port = 1500;

v = split(version, sep:".", keep:FALSE);

if (!isExpress)
{
 if ( ( int(v[0]) < 5 ) ||
      ( int(v[0]) == 5 && int(v[1]) < 2 ) ||
      ( int(v[0]) == 5 && int(v[1]) == 2 && int(v[2]) < 9 ) ||
      ( int(v[0]) == 5 && int(v[1]) == 3 && int(v[2]) < 4 ) )
  security_hole(port);
}
else
{
 if ( ( int(v[0]) < 5 ) ||
      ( int(v[0]) == 5 && int(v[1]) < 3 ) ||
      ( int(v[0]) == 5 && int(v[1]) == 3 && int(v[2]) < 7 ) ||
      ( int(v[0]) == 5 && int(v[1]) == 3 && int(v[2]) == 7 && int(v[3]) < 1 ) )
   security_hole(port); 
}
