#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote webmail server is affected by a cross-site scripting
vulnerability. 

Description :

The remote host is running IceWarp Merak Mail Server - a webmail
server for Windows and Linux. 

According to its banner, the version of IceWarp installed on the
remote host fails to properly sanitize e-mail messages before
displaying them.  If a user reads a specially-crafted message, a
remote attacker could leverage this issue to inject arbitrary HTML and
script code into a user's browser to be executed within the security
context of the affected application. 

See also :

http://www.nessus.org/u?4e1a7b62

Solution :

Upgrade to Icewarp Merak Mail Server version 9.0.0 or later as that
reportedly resolves the issue. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";


if (description)
{
  script_id(26069);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-5046");
  script_bugtraq_id(25708);
  script_xref(name:"OSVDB", value:"37428");

  script_name(english:"IceWarp Merak Mail Server < 9.0.0 Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks version of Icewarp");

  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("find_service_3digits.nasl", "doublecheck_std_services.nasl");
  if ( NASL_LEVEL >= 3000 )
    script_require_ports("Services/smtp", 25, "Services/pop3", 110, "Services/nntp", 119, "Services/imap", 143, "Services/www", 32000);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("imap_func.inc");
include("misc_func.inc");
include("pop3_func.inc");
include("smtp_func.inc");


# Make sure the webmail component is accessible.
http_port = get_http_port(default:32000);
if (!get_port_state(http_port)) exit(0);

banner = get_http_banner(port:http_port);
if (!banner || "IceWarp" >!< banner) exit(0);


# Try to get the version number from a banner.
ver = NULL;
service = NULL;
#
# - SMTP.
if (isnull(ver))
{
  port = get_kb_item("Services/smtp");
  if (!port) port = 25;
  if (get_port_state(port))
  {
    banner = get_smtp_banner(port:port);
    if (banner && (" ESMTP IceWarp " >< banner || " ESMTP Merak " >< banner))
    {
      pat = " ESMTP (IceWarp|Merak) ([0-9][0-9.-]+);";
      matches = egrep(pattern:pat, string:banner);
      if (matches)
      {
        foreach match (split(matches))
        {
          match = chomp(match);
          item = eregmatch(pattern:pat, string:match);
          if (!isnull(item))
          {
            ver = item[2];
            service = "SMTP";
            break;
          }
        }
      }
    }
    if (isnull(ver) && !thorough_tests) exit(0);
  }
}
# - POP3
if (isnull(ver))
{
  port = get_kb_item("Services/pop3");
  if (!port) port = 110;
  if (get_port_state(port))
  {
    banner = get_pop3_banner(port:port);
    if (banner && " POP3 " >< banner && (" IceWarp " >< banner || " Merak " >< banner))
    {
      pat = " (IceWarp|Merak) ([0-9][0-9.-]+) POP3 ";
      matches = egrep(pattern:pat, string:banner);
      if (matches)
      {
        foreach match (split(matches))
        {
          match = chomp(match);
          item = eregmatch(pattern:pat, string:match);
          if (!isnull(item))
          {
            ver = item[2];
            service = "POP3";
            break;
          }
        }
      }
    }
    if (isnull(ver) && !thorough_tests) exit(0);
  }
}
# - IMAP.
if (isnull(ver))
{
  port = get_kb_item("Services/imap");
  if (!port) port = 143;
  if (get_port_state(port))
  {
    banner = get_imap_banner(port:port);
    if (banner && " IMAP4" >< banner && (" IceWarp " >< banner || " Merak " >< banner))
    {
      pat = " (IceWarp|Merak) ([0-9][0-9.-]+) IMAP4";
      matches = egrep(pattern:pat, string:banner);
      if (matches)
      {
        foreach match (split(matches))
        {
          match = chomp(match);
          item = eregmatch(pattern:pat, string:match);
          if (!isnull(item))
          {
            ver = item[2];
            service = "IMAP";
            break;
          }
        }
      }
    }
    if (isnull(ver) && !thorough_tests) exit(0);
  }
}


# There's a problem if the version is < 9.0.0.
if (ver && ver =~ "^[0-8]\.")
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "According to its ", service, " banner, the remote is running IceWarp Merak Mail\n",
    "Server version ", ver, "."
  );
  security_warning(port:http_port, data:report);
}
