#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

There is a peer-to-peer file sharing application installed on the
remote Windows host. 

Description :

iMesh is installed on the remote Windows host.  iMesh is a peer-to-
peer file sharing application. 

Make sure the use of this program fits with your corporate security
policy. 

See also :

http://www.imesh.com/

Solution :

Remove this software if its use does not match your corporate security
policy. 

Risk factor : 

None";


if (description)
{
  script_id(29729);
  script_version("$Revision: 1.1 $");

  script_name(english:"iMesh P2P Client Detection");
  script_summary(english:"Checks for iMesh");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Peer-To-Peer File Sharing");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


include("smb_func.inc");
include("smb_hotfixes.inc");


# Connect to the appropriate share.
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) {
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Make sure it's installed.
exe = NULL;

key = "SOFTWARE\Classes\Applications\iMesh.exe\shell\open\command";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  info = RegQueryInfoKey(handle:key_h);
  for (i=0; i<info[0]; ++i) {
    value = RegEnumValue(handle:key_h, index:i);
    if (!isnull(value))
    {
      subkey = value[1];

      # Get the install path.
      item = RegQueryValue(handle:key_h, item:subkey);
      if (!isnull(item))
      {
        exe = item[1];
        exe = ereg_replace(pattern:'^"([^"]+)".*$', replace:"\1", string:exe);
      }
    }
    if (exe && exe =~ "^[A-Za-z]:.+") break;
  }
  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(exe))
{
  NetUseDel();
  exit(0);
}


# Grab the file version.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:exe);
exe2 = ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1", string:exe);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe2,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
ver = NULL;
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}
NetUseDel();


# Check the version number.
if (!isnull(ver))
{
  path = ereg_replace(pattern:"^(.*)\\[^\\]+\.exe", replace:"\1", string:exe, icase:TRUE);
  version = string(ver[0], ".", ver[1], ".", ver[2], ".", ver[3]);

  set_kb_item(name:"SMB/iMesh/Path",    value:path);
  set_kb_item(name:"SMB/iMesh/Version", value:version);

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "  Path    : ", path, "\n",
    "  Version : ", version, "\n"
  );
  security_note(port:port, data:report);
}
