#
# 
# (C) 2007 Tenable Network Security
#
# This script is released under one of the Tenable Script Licenses and may not
# be used from within scripts released under another license without the
# authorization from Tenable Network Security Inc.
#
# See the following licenses for details :
#  http://www.nessus.org/plugins/RegisteredFeed.pdf
#  http://www.nessus.org/plugins/TenableCommercial.pdf
#  http://www.nessus.org/plugins/DirectFeed.pdf
#  http://www.nessus.org/plugins/DirectFeedCommercial.pdf
#
#
# @NOGPL@
#
#

#----------------------------------------------------------------------------#
# IP									     #
#----------------------------------------------------------------------------#


#
# Definition of the IP structure
#

ip6_sizes = make_array(
		"ip6_vfc",  8,
		"ip6_flow",   24,
		"ip6_plen",   16,
		"ip6_nxt",     8,
		"ip6_hlim",    8,
		"ip6_src",128,
		"ip6_dst",128);

ip6_struct = make_list("ip6_vfc", 
		      "ip6_class", 
		      "ip6_flow", 
		      "ip6_plen", 
		      "ip6_nxt", 
		      "ip6_hlim", 
		      "ip6_src", 
		      "ip6_dst");





#
# Set any IP element
#

function ip6_set(ip6, ip6_vfc, ip6_flow, ip6_plen, ip6_nxt, ip6_hlim, ip6_src, ip6_dst)
{
 local_var head,  t;
 local_var ret;

 if ( ip6["type"] != "ip6" )
	return ip6;

 ip6 = ip6["data"];
 
 if ( ! isnull(ip6_vfc) )  ip6["ip6_vfc"] = ip6_vfc;
 if ( ! isnull(ip6_flow) ) ip6["ip6_flow"]    = ip6_flow;
 if ( ! isnull(ip6_plen) ) ip6["ip6_plen"]    = ip6_plen;
 if ( ! isnull(ip6_nxt) )  ip6["ip6_nxt"]     = ip6_nxt;
 if ( ! isnull(ip6_hlim) )  ip6["ip6_hlim"]     = ip6_hlim;
 if ( ! isnull(ip6_src) )  ip6["ip6_src"]     = ip6_src;
 if ( ! isnull(ip6_dst) )  ip6["ip6_dst"]     = ip6_dst;

 ret["data"] = ip6;
 ret["type"] = "ip6";
 return ret;
} 


#
# Create a fresh new packet, with useful default values
#
function ip6(ip6_vfc, ip6_flow, ip6_plen, ip6_nxt, ip6_hlim, ip6_src, ip6_dst)
{
 local_var empty;
 if ( isnull(ip6_vfc) )  ip6_vfc   = 6 << 4;
 if ( isnull(ip6_flow) ) ip6_flow = 0;
 if ( isnull(ip6_plen) ) ip6_plen = 0;
 if ( isnull(ip6_nxt) ) ip6_nxt = IPPROTO_TCP;
 if ( isnull(ip6_hlim) ) ip6_hlim = 64;
 if ( isnull(ip6_src ) ) ip6_src = this_host_raw();
 if ( isnull(ip6_dst ) ) ip6_dst = get_host_raw_ip();

 empty["type"] = "ip6";
 empty["data"] = NULL;

 return ip6_set(ip6:empty,
		ip6_vfc:ip6_vfc,
		ip6_flow:ip6_flow,
		ip6_plen:ip6_plen,
		ip6_nxt:ip6_nxt,
		ip6_hlim:ip6_hlim,
		ip6_src:ip6_src,
		ip6_dst:ip6_dst);
}



#
# Get any item in our IP packet
#
function ip6_get(ip6, element)
{
 local_var t, l, ret;
 if ( isnull(ip6) || ip6["type"] != "ip6" )
 {
  display("ip6_get: invalid 'ip6' argument\n");
  return NULL;
 }
 ip6 = ip6["data"];
 return ip6[element];
}




#
# Transforms an IPv6 structure into a blob which is suitable to be
# sent over the network
#
function mkip6()
{
 local_var item, ret, n, b, ip6;

 ip6 = _FCT_ANON_ARGS[0];
 
 if ( ip6["type"] != "ip6") 
 {
   display("mkip6 : Bad packet type - ", ip6["type"], "\n");
 } 

 ip6 = ip6["data"];

 foreach item ( ip6_struct )
 {
     if ( ip6_sizes[item] == 24 )
	{
	 n = ord(ret[strlen(ret) - 1]);
	 ret = substr(ret, 0, strlen(ret) - 2);
	 ret += mkdword(n << 24 | ip6[item]);
	}
     if ( ip6_sizes[item] == 8 )   ret += mkbyte(ip6[item]);
     if ( ip6_sizes[item] == 16 )  ret += mkword(ip6[item]);
     if ( ip6_sizes[item] == 128 ) ret += ip6[item]; # 128bits -> can only be ip_src or ip_dst
 }

 return ret;
}

