#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote Windows host contains a program that is prone to a buffer
overflow attack. 

Description :

IMail Client, a tool for administering Ipswitch IMail Server, is
installed on the remote Windows host. 

The version of IMail Client on the remote host contains a boundary
error that can be triggered by a long 'boundary' parameter in when
processing emails with multipart MIME data.  If an attacker can trick
the Ipswitch Mail Server administrator to open a specially-crafted
email using the affected application, he can leverage this issue to
execute arbitrary code subject to the user's privileges. 

See also :

http://secunia.com/secunia_research/2007-81/advisory/
http://www.securityfocus.com/archive/1/482988

Solution :

Delete the IMail Client application. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(27590);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-4345");
  script_bugtraq_id(26252);
  script_xref(name:"OSVDB", value:"39389");

  script_name(english:"Ipswitch IMail Client Buffer Overflow Vulnerability");
  script_summary(english:"Checks version of IMail Client");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/name", "SMB/login", "SMB/password");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");


# Connect to the appropriate share.
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) exit(0);


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Determine where it's installed.
path = NULL;

key = "SOFTWARE\Ipswitch\IMail\Global";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h)) {
  value = RegQueryValue(handle:key_h, item:"TopDir");
  if (!isnull(value)) path = value[1];

  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(path))
{
  NetUseDel();
  exit(0);  
}


# Determine the version of the IMail Client.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
exe =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\IMail.exe", string:path);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
if (isnull(fh))
{
  NetUseDel();
  exit(0);
}
ver = GetFileVersion(handle:fh);
CloseFile(handle:fh);
NetUseDel();
if (isnull(ver)) exit(0);


# If it's an affected version...
if (report_paranoia > 1)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Note that Nessus did not check the version of the IMail Client installed\n",
    "on the remote host because of the Report Paranoia setting in effect when\n",
    "this scan was run.\n"
  );
  security_hole(port:port, data:report);
}
else if (
  ver[0] < 7 ||
  (
    ver[0] == 7 && 
    (
      ver[1] < 10 ||
      (
        ver[1] == 10 && 
        (
          ver[2] < 5 ||
          (ver[2] == 5 && ver[3] == 0)
        )
      )
    )
  )
)
{
  version = string(ver[0], ".", ver[1], ".", ver[2], ".", ver[3]);
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Version ", version, " of the IMail Client is installed on the remote host under :\n",
    "\n",
    "  ", path, "\n"
  );
  security_hole(port:port, data:report);
}

