#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25762);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-3959");
  script_bugtraq_id(25031);
  script_xref(name:"OSVDB", value:"36223");

  script_name(english:"Ipswitch IM Server < 2.07 Denial of Service Vulnerability");
  script_summary(english:"Checks version of IMServer.exe");
 
 desc = "
Synopsis :

The remote Windows host contains an application that is affected by a
denial of service vulnerability. 

Description :

Ipswitch Instant Messaging Server, a secure, instant messaging product
targetted at businesses, is installed on the remote Windows host. 

The version of Instant Messaging Server on the remote host reportedly
allows an unauthenticated attacker to overwrite a destructor and crash
the application when it attempts to process malicious traffic in the
'DoAttachVideoSender', 'DoAttachVideoReceiver', 'DoAttachAudioSender',
or 'DoAttachAudioReceiver' functions. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=566
http://www.securityfocus.com/archive/1/474469/30/0/threaded
http://www.ipswitch.com/support/instant_messaging/patch-upgrades.asp

Solution :

Upgrade to version 2.07 of the IM Server.

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_enum_services.nasl", "smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Connect to the appropriate share.
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) {
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Make sure it's installed.
path = NULL;
key = "SOFTWARE\Ipswitch\Messenger Server\Settings";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:"Install Directory");
  if (!isnull(value)) path = value[1];

  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(path))
{
  NetUseDel();
  exit(0);
}



# Grab the file version of the server.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
exe =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\IMServer.exe", string:path);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
ver = NULL;
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}


# Check the version number.
if (!isnull(ver))
{
  fix = split("2.0.7.0", sep:'.', keep:FALSE);
  for (i=0; i<4; i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if ((ver[i] < fix[i]))
    {
      security_warning(port);
      break;
    }
    else if (ver[i] > fix[i])
      break;
}


# Clean up.
NetUseDel();
