#
#  (C) Tenable Network Security
#


if (description)
{
  script_id(26000);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3752");
  script_bugtraq_id(25567);
  script_xref(name:"OSVDB", value:"38528");

  script_name(english:"iTunes < 7.4 Malformed Music File Heap Overflow (Network Check)");
  script_summary(english:"Check the version of iTunes"); 
 
 desc = "
Synopsis :

The remote host contains an application that is affected by a
remote code execution flaw. 

Description :

The remote host is running iTunes, a popular jukebox program. 

The remote version of iTunes is vulnerable to a heap overflow when
it parses a specially crafted MP4/AAC file.  By tricking a user into
opening such a file, a remote attacker may be able to leverage this
issue to execute arbitrary code on the affected host, subject to the
privileges of the user running the application. 

See also :

http://docs.info.apple.com/article.html?artnum=306404

Solution :

Upgrade to iTunes 7.4 or later. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain a shell remotely");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("itunes_sharing.nasl");
  script_require_ports("Services/www", 3689);

  exit(0);
}



include("http_func.inc");


port = get_http_port(default:3689);
if (!get_port_state(port)) exit(0);
if (!get_kb_item("iTunes/" + port + "/enabled")) exit(0);


# Do a banner check (if music sharing is enabled and the app is running).
banner = get_http_banner(port:port);
if (
  banner && 
  egrep(pattern:"^DAAP-Server: iTunes/([0-6]\.|7\.[0-3]([^0-9]|$))", string:banner)
) security_hole(port);
