#
#  (C) Tenable Network Security
#

if(description)
{
 script_id(16226);
 script_cve_id("CVE-2004-1029");
 script_bugtraq_id(12317);
 script_version("$Revision: 1.4 $");

 name["english"] = "Sun JRE Java Plugin-In Multiple Applet Vulnerabilities";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using a vulnerable version of Sun Java Runtime
Plug-in, an addon to many web browser like Internet Explorer to
display java applets.

Two security issues have been reported in the remote version of this product :

- An untrusted applet may escalate its privileges in order to read, write
  or execute files on the remote system ;

- An untrusted applet may interfer with trusted applets loaded on the same
  page ;

Solution: Upgrade to JRE 1.4.2_06 or 1.3.1_13
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Java JRE plugin";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("java_jre_version_invocation.nasl");
 script_require_keys("SMB/Java/JRE/Version");
 exit(0);
}




version = get_kb_item("SMB/Java/JRE/Version");
if ( ! version ) exit(0);
if(egrep(pattern:"^1\.(3\.(0.*|1[^_].*|1_[0-9][^0-9].*|1_1[0-2].*)|4\.([0-1]\..*|2_0[0-5].*))", string:version))
    security_hole(port);
