#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23842);
  script_version("$Revision: 1.2 $");

  script_name(english:"JBoss JMX Console Unrestricted Access Vulnerability");
  script_summary(english:"Tries to access the JMX and Web Consoles");

  desc = "
Synopsis :

The remote web server allows unauthenticated access to an
administrative Java servlet. 

Description :

The remote web server appears to be a version of JBoss that allows
unauthenticated access to the JMX and/or Web Console servlets used to
manage JBoss and its services.  A remote attacker can leverage this
issue to disclose sensitive information about the affected application
or even take control of it. 

See also :

http://wiki.jboss.org/wiki/Wiki.jsp?page=SecureTheJmxConsole

Solution :

Follow the Wiki article referenced above to secure access to the JMX /
Web Console. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8080);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:8080);
if (!get_port_state(port)) exit(0);


# Check whether access is allowed.
foreach url (make_list("/jmx-console/", "/web-console/"))
{
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    ("jmx" >< url && 'form action="HtmlAdaptor?action=displayMBeans"' >< res) ||
    ("web" >< url && ' src="ServerInfo.jsp"' >< res)
  )
  {
    security_hole(port);
    exit(0);
  }
}
