#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24758);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-1281");
  script_bugtraq_id(22795);
  script_xref(name:"OSVDB", value:"33847");

  script_name(english:"Kaspersky Antivirus UPX File Decompression Denial of Service Vulnerability");
  script_summary(english:"Checks date of virus signatures");

  desc = "
Synopsis :

The remote Windows host contains an application that is prone to a
denial of service issue. 

Description :

The version of Kaspersky Antivirus installed on the remote host
reportedly may enter an infinite loop when it attempts to process an
executable with specially-crafted compressed UPX data.  A remote
attacker may be able to exploit this issue to cause the affected host
to consume all available CPU cycles, thereby denying service to users
of the affected host. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=485
http://www.securityfocus.com/archive/1/461738/30/0/threaded

Solution :

Update the virus signatures on or after 02/07/2007 and restart the
computer. 

Risk factor :

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("kaspersky_installed.nasl");
  script_require_keys("Antivirus/Kaspersky/sigs");

  exit(0);
}


sigs = get_kb_item("Antivirus/Kaspersky/sigs");
if (sigs)
{
  sigs = split(sigs, sep:'/', keep:FALSE);
  if (
    sigs[0] == "unknown" ||
    int(sigs[2]) < 2007 || 
    (
      int(sigs[2]) == 2007 && 
      (
        int(sigs[0]) < 2 ||
        (int(sigs[0]) == 2 && int(sigs[1]) < 7)
      )
    )
  )
  security_hole(get_kb_item("SMB/transport"));
}
