#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30053);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2008-0395");
  script_xref(name:"OSVDB", value:"40517");

  script_name(english:"Kayako SupportSuite syncml Information Disclosure Vulnerability");
  script_summary(english:"Requests Kayako's syncml/index.php script");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
an information disclosure issue. 

Description :

The version of Kayako installed on the remote host returns PHP's
'$_SERVER' superglobal variable in response to a request for Kayako's
'syncml/index.php' page.  This variable contains information about the
remote web server, some of which might be sensitive. 

See also :

http://www.waraxe.us/advisory-63.html
http://www.securityfocus.com/archive/1/486762/30/0/threaded

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/kayako", "/helpdesk", "/esupport", "/support", "/supportsuite", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue.
  url = string(dir, "/syncml/index.php");

  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it's affected.
  if (
    'Array' >< res &&
    egrep(pattern:"\[(DOCUMENT_ROOT|PATH|QUERY_STRING)\] =>", string:res)
  )
  {
    # Make sure it's Kayako unless we're being paranoid.
    vuln = FALSE;
    if (report_paranoia < 2)
    {
      if (strlen(dir) == 0) dir = "/";
      req2 = http_get(item:dir, port:port);
      res2 = http_keepalive_send_recv(port:port, data:req2, bodyonly:TRUE);
      if (res2 == NULL) exit(0);

      if ("Powered by Kayako" >< res2) vuln = TRUE;
    }
    else vuln = TRUE;

    if (vuln)
    {
      if (report_verbosity)
      {
        if (ENCAPS_IP >= ENCAPS_SSLv23) url = string("https://", get_host_name(), ":", port, url);
        else url = string("http://", get_host_name(), ":", port, url);

        report = string(
          "\n",
          "Here are the contents of PHP's '$_SERVER' superglobals array from\n",
          "the remote host, obtained in response to a GET request for\n", 
          url, " :\n",
          "\n",
          res,
          "\n"
        );
        security_warning(port:port, extra:report);
      }
      else security_warning(port);

      exit(0);
    }
  }
}
