#
# (C) Tenable Network Security
#

if(description)
{
  script_id(10723);
  script_version ("$Revision: 1.22 $");

  script_xref(name:"OSVDB", value:"9723");

  script_name(english:"LDAP allows anonymous binds");

  desc["english"] = "
Synopsis :

The remote LDAP server allows anonymous access. 

Description :

The LDAP server on the remote host is currently configured such that a
user can connect to it without authentication - via a 'NULL BIND' -
and query it for information.  Although the queries that are allowed
are likely to be fairly restricted, this may result in disclosure of
information that an attacker could find useful. 

Solution :

Configure the LDAP server so that it does not allow NULL BINDs. 

Risk factor :

Medium / CVSS Base Score : 5.0 
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


  script_description(english:desc["english"]);
  script_summary(english:"Check for LDAP null bind");
  script_category(ACT_GATHER_INFO);
  script_family(english:"Remote file access");
  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");

  script_dependencies("ldap_detect.nasl");
  script_require_ports("Services/ldap", 389);

  exit(0);
}


include("ldap_func.inc");

port = get_kb_item("Services/ldap");
if (!port) port = 389;

soc = open_sock_tcp(port);
if (!soc) exit(0);

ldap_init(socket:soc);

bind = ldap_bind_request();
ret = ldap_request_sendrecv(data:bind);

if (isnull(ret) || ret[0] != LDAP_BIND_RESPONSE)
  exit(0);

data = ldap_parse_bind_response(data:ret[1]);
if (isnull(data))
  exit(0);

if (data[0] == 0)
  security_warning(port);
