#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(26057);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-4727");
  script_bugtraq_id(25622);
  script_xref(name:"OSVDB", value:"36933");

  script_name(english:"Lighttpd mod_fastcgi Header Overflow Vulnerability");
  script_summary(english:"Sends a long header to lighttpd");

  desc = "
Synopsis :

The remote web server is susceptible to a buffer overflow
vulnerability. 

Description :

The remote web server appears to be lighttpd running with the FastCGI
module (mod_fastcgi). 

The version of that module on the remote host appears to be
affected by a buffer overflow vulnerability.  By sending a specially-
crafted request with a long header, a remote attacker may be able to
exploit this issue to add or replace headers passed to PHP, such as
SCRIPT_FILENAME, which in turn could result in arbitrary code
execution. 

See also :

http://secweb.se/en/advisories/lighttpd-fastcgi-remote-vulnerability/
http://www.lighttpd.net/assets/2007/9/9/lighttpd_sa_2007_12.txt

Solution :

Either disable the FastCGI module or upgrade to lighttpd 1.4.18 or
later. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"Web Servers");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_keys("www/lighttpd");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Make sure the banner looks like lighttpd w/ FastCGI (or some type of PHP support).
banner = get_http_banner(port:port);
if (
  !banner || 
  "lighttpd/" >!< banner ||
  "X-Powered-By: PHP" >!< banner
) exit(0);


# Make sure the server itself works.
url = "/";
req = http_get(item:url, port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
if (res == NULL) exit(0);


# If it does...
if (egrep(string:res, pattern:"^HTTP/.* 200 OK"))
{
  # Send the same request but with a long header.
  req = str_replace(
    string:req,
    find:"User-Agent:",
    replace:string(
      # nb: the size of the environment needs to exceed FCGI_MAX_LENGTH, 
      #     as defined in src/fastcgi.h. By default, it's 0xffff so 
      #     this is probably more than what we need.
      "Nessus: ", crap(0xffff), "\r\n",
      "User-Agent:"
    )
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # There's a problem unless we get a 400 response.
  if (!egrep(string:res, pattern:"^HTTP/.* 400 "))
  {
    security_warning(port);
  }
}
