#
# (C) Tenable Network Security
#
#


#
# (C) Tenable Network Security, Inc.
#


if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(30255);
 script_version ("$Revision: 1.2 $");
 if (NASL_LEVEL >= 3000)
  {
    script_cve_id(
      "CVE-2007-0355",
      "CVE-2007-4568",
      "CVE-2007-6015",
      "CVE-2008-0035",
      "CVE-2008-0037",
      "CVE-2008-0038",
      "CVE-2008-0039",
      "CVE-2008-0040",
      "CVE-2008-0041",
      "CVE-2008-0042"
    );
    script_bugtraq_id(22101, 25898, 26791, 27296);
    script_xref(name:"milw0rm", value:"3151");
    script_xref(name:"OSVDB", value:"32693");
 }
 name["english"] = "Mac OS X < 10.5.2";
 
 script_name(english:name["english"]);
  desc = "
Synopsis :

The remote host is missing a Mac OS X update that fixes various
security issues. 

Description :

The remote host is running a version of Mac OS X 10.5 that
is older than version 10.5.2.

Mac OS X 10.5.2 contains several security fixes for a number 
of programs. 

See also : 

http://docs.info.apple.com/article.html?artnum=307430
http://lists.apple.com/archives/security-announce/2008/Feb/msg00002.html
http://www.securityfocus.com/advisories/13987

Solution : 

Upgrade to Mac OS X 10.5.2

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
 

 script_description(english:desc);
 
 summary["english"] = "Check for the version of Mac OS X";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl", "os_fingerprint.nasl");
 exit(0);
}


os = get_kb_item("Host/MacOSX/Version");
if ( ! os ) os = get_kb_item("Host/OS");
if ( ! os ) exit(0);
if ( ereg(pattern:"Mac OS X 10\.5\.[01]([^0-9]|$)", string:os)) security_hole(0);
