#TRUSTED 0fc88b7dbd08c5aa4626ed0a0984c2478c16bb156614cf26e8f5a46650cc9d4f76cf9d7c2f2639c67282b925563b9ad4510ab1eeb838c9dfa9589c5eaf03982676ceadcadb21ea0d3706bce4b3920d9591bb12343dcb52b1e2e5fbf561bd50be778d28aabefccf21080c4dc3966818873700bbbefba05cb2578b818137e9005785230010157ae07ec25cfdcecffcd6dd21dd32ab8548719aa880848af8404583ba240175dfcef36dc2e63718c0a9eae0c0b52488779d213d2c50e8bf6d329d1b05b08e542ba770b0b332c23c6c6f12d98c0f0a978a20c53a37b2d7a2186dfb61769d642a78f5318e457e3b31405241dbe55fb94b3836c34304ef0ef7ca101d7b474427d45657060f62aa762b14d771532450f3bc2f79908314c2c2eae084667c7c1d503efb819facd2173307f32fb09e36324a0b4623eecff79ae5076c9544a79e2eef80ac2c1472ccc3accb2c79a5128b9ce1a623c798252b9fa32f4ae6a8e3ccefa3d9d629284f837a75569547fbd676c2d5e3482d0983e47dc5817cee6a5bd71bd113ef1dc6723f0a456726f858c5ec2d15126d9437ea71b53e89afcbbab87e9852cd3fe3e165ed5a3f681959b988f426e571c686050ff168faee3a3f5650ef5d35f4a523e0eb77784f266e5e2e3c8c3181b1dadedb2289dc7837089d7e003aea6cf1c67dd3716b7170743d2fa7445ae370195579ceb48838131aaf4e442a
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(24241);
 script_version ("1.0");
 script_cve_id("CVE-2006-6292");
 name["english"] = "Mac OS X Airport Update 2007-001";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a Mac OS X update which fixes a security
issue.

Description :

The remote host is running a version of Mac OS X 10.4 which does not have
the Airport Update 2007-001 applied.

This update fixes a flaw in the wireless drivers which may allow an attacker
to crash a host by sending a malformed frame.

Solution : 

Install the Airport Update 2007-001 :

http://www.nessus.org/u?0af16cb0

See also : 

http://docs.info.apple.com/article.html?artnum=305031

Risk factor :

Medium / CVSS Base Score : 5.7
(CVSS2#AV:A/AC:M/Au:N/C:N/I:N/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the presence of the SecUpdate 2007-001";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}

include("ssh_func.inc");
include("macosx_func.inc");

function exec(cmd)
{
 local_var soc, buf;

 if ( islocalhost() )
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
 else
 {
  soc = ssh_login_or_reuse_connection();
  if ( ! soc ) exit(0);
  buf = ssh_cmd(socket:soc, cmd:cmd);
  ssh_close_connection();
 }


 buf = chomp(buf);
 return buf;
}

uname = get_kb_item("Host/uname");
if ( ! uname ) exit(0);
if ( ! egrep(pattern:"Darwin.* (8\.)", string:uname) ) exit(0);

packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);
if ( "AirPortExtremeUpdate2007001.pkg" >< packages ) exit(0);

buf = exec(cmd:"system_profiler SPHardwareDataType");
if ( ! buf )exit(0);
if ("Intel Core Duo" >!< buf ) exit(0); # Only Core [1] Duo affected


cmd = _GetBundleVersionCmd(file:"AirPortAtheros5424.kext", path:"/System/Library/Extensions/IO80211Family.kext/Contents/PlugIns", label:"SourceVersion");
buf = exec(cmd:cmd);
if ( strlen(buf) && int(buf) < 2214600 ) { security_warning(0); exit(0); }

cmd = _GetBundleVersionCmd(file:"AppleAirPortBrcm4311.kext", path:"/System/Library/Extensions/IO80211Family.kext/Contents/PlugIns", label:"SourceVersion");
buf = exec(cmd:cmd);
if ( strlen(buf) && int(buf) < 2217601 ) { security_warning(0); exit(0); }
