#TRUSTED 701ea57b615cf1862e8c920a44d0535664e38fff915c52bd8554bd374fc1947acac7190c4dfd047357cbceba59072e8e2c15bb61b358208c9ed5935fb85b41a712980dffdfaf7a21fbdf08daae2a81bfb03f8e3ce50a9695eb2961dfb453e78ceb2d3bd1bb16ac1d441eb463d9d3f374975d2113764275d12b7942aa1612baab32550647a2b5ae04d69fef8b0c930c35c1eed02c1a043ba1833730bceed969df8a902bd55528a326dcfc4e7ea49b355e529512b97f7a9c18e7de4f740de6be315b01a04c596e49afd62e8dc056d056dde2729b2964687dff6a671a2d46e607fe97a451e1f7d76b9fe8fad63d906e0bc8164b1ecb332470213052a5436f42670118b13c33738aca7ae89c0fbc3000dfccb95b59b06d66457e0034e2372c479f3334650c33dd05a023c68890cf92416de229d966b3c05a57cbdf2ff1ab3519a6f11b2fefe2e4ef0d1b3758e74f1319a57813492eb2ec87f5a83c30029556605e8065115edbb97de46419e8bc5548283e0dfab1b2243eac3931f2ade579f54e188844f1624c77d023ae7cbd72d1213d8c70d87f1702d2cedef3955ca2b86696490f2c308944b665568a3455dea4921cb3b6cc7dc7483980fa121096e1678c6876364a879fa3ff4a6d4a70959b4589f04cd26d49edf1477055893c0f7e0c6cd1afce5c53e53816c861958e3895d723625e3e9fb185dfbeb9f3f1f35bd3f888f9db64
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(18099);
 script_version ("1.5");
 script_cve_id("CVE-2005-0193");
 script_bugtraq_id (12334);
 name["english"] = "Mac OS X Security Update 2005-004";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote operating system is missing a security update

Description :


The remote host is missing Security Update 2005-004. This security
update contains security fixes for the following application :

- iSync (local privilege escalation)

Solution : 

http://docs.info.apple.com/article.html?artnum=301326

Risk factor : 

High / CVSS Base Score : 7.2
(CVSS2#AV:L/AC:L/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Security Update 2005-004";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");

function exec(cmd)
{
 local_var soc, buf;

 if ( islocalhost() )
  buf = pread(cmd:"bash", argv:make_list("bash", "-c", cmd));
 else
 {
  soc = ssh_login_or_reuse_connection();
  if ( ! soc ) exit(0);
  buf = ssh_cmd(socket:soc, cmd:cmd);
  ssh_close_connection();
 }

 if ( buf !~ "^[0-9]" ) exit(0);

 buf = chomp(buf);
 return buf;
}

packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);


uname = get_kb_item("Host/uname");
# MacOS X 10.2.8, 10.3.9 only
if ( egrep(pattern:"Darwin.* (6\.8\.|7\.[789]\.)", string:uname) )
{
 cmd = _GetBundleVersionCmd(file:"SymbianConduit.bundle", path:"/System/Library/SyncServices", label:"SourceVersion");
 buf = exec(cmd:cmd);
 if ( int(buf) > 0 && int(buf) < 840200 ) security_hole(0);
}
 
