#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(18437);
 script_version ("$Revision: 1.4 $");

 if (NASL_LEVEL >= 3000)
 {
  script_cve_id(
   "CVE-2005-0524",
   "CVE-2005-0525",
   "CVE-2005-1042",
   "CVE-2005-1043",
   "CVE-2005-1333",
   "CVE-2005-1343",
   "CVE-2005-1720",
   "CVE-2005-1721",
   "CVE-2005-1722",
   "CVE-2005-1723",
   "CVE-2005-1724",
   "CVE-2005-1725",
   "CVE-2005-1726",
   "CVE-2005-1727",
   "CVE-2005-1728"
  );
 }
 script_bugtraq_id(13491, 13899);

 name["english"] = "Mac OS X Security Update 2005-006";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is missing Security Update 2005-006. This security
update contains security fixes for the following application :

- AFP Server
- Bluetooth
- CoreGraphics
- Folder Permissions
- launchd
- LaunchServices
- NFS
- PHP
- VPN

Solution : http://docs.info.apple.com/article.html?artnum=301742
Risk factor : High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for Security Update 2005-006";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);


uname = get_kb_item("Host/uname");
# MacOS X 10.4.1
if ( egrep(pattern:"Darwin.* (7\.[0-9]\.|8\.[01]\.)", string:uname) )
{
  if (!egrep(pattern:"^SecUpd(Srvr)?2005-006", string:packages)) security_hole(0);
}
