#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(25297);
 script_version ("$Revision: 1.3 $");
 script_cve_id("CVE-2007-0740", "CVE-2007-0493", "CVE-2007-0494", "CVE-2007-4095", "CVE-2007-4096", "CVE-2007-0750", "CVE-2007-0751", "CVE-2007-1558", "CVE-2007-1536", "CVE-2007-2390", "CVE-2007-2386", "CVE-2007-0752", "CVE-2006-5467", "CVE-2006-6303", "CVE-2006-4573", "CVE-2005-3011", "CVE-2007-0753");
 script_bugtraq_id(24144, 24159);
 name["english"] = "Mac OS X Security Update 2007-005";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a Mac OS X update which fixes a security
issue.

Description :

The remote host is running a version of Mac OS X 10.4 or 10.3 which does not 
have the security update 2007-005 applied.

This update fixes security flaws in the following applications :

Alias Manager
BIND
CoreGraphics
crontabs
fetchmail
file
iChat
mDNSResponder
PPP
ruby
screen
texinfo
VPN


Solution : 

Install the security update 2007-005 :

http://www.apple.com/support/downloads/securityupdate2007005universal.html

See also : 

http://docs.info.apple.com/article.html?artnum=305530

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the presence of the SecUpdate 2007-004";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);



uname = get_kb_item("Host/uname");
if ( egrep(pattern:"Darwin.* (7\.[0-9]\.|8\.[0-9]\.)", string:uname) )
{
  if (!egrep(pattern:"^SecUpd(Srvr)?2007-005", string:packages)) security_hole(0);
}
